/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db.access.def;

import com.horizon.db.access.IExeQueryForUpdate;
import com.horizon.db.access.def.ExeBase;
import com.horizon.db.resultset.ResultSetProcessor;
import com.horizon.db.resultset.ResultSetProcessorImpl4List;
import com.horizon.db.resultset.ResultSetProcessorImpl4Map;
import com.horizon.db.resultset.ResultSetProcessorImpl4Object;
import com.horizon.db.xconnection.InvalidIdentifierException;
import com.horizon.db.xlob.XlobProcessor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExeQueryForUpdate
extends ExeBase
implements IExeQueryForUpdate {
    public static final String CONN_KEY = "CONNECT";
    public static final String COMMIT_TYPE = "AUTOCOMMIT";
    public static final String RESULT_LIST = "RESULTLIST";
    private static Logger logger = LoggerFactory.getLogger(ExeQueryForUpdate.class);
    private ResultSetProcessor rsProcessor4List = new ResultSetProcessorImpl4List();
    private ResultSetProcessor rsProcessor4Map = new ResultSetProcessorImpl4Map();
    private ResultSetProcessorImpl4Object rsProcessor4Object = new ResultSetProcessorImpl4Object();

    @Override
    public Map getMultiList(String dbIdentifier, String strSQL, List lstCondition) {
        Map rsLst = this.executeQueryForUpdate(dbIdentifier, strSQL, lstCondition, this.rsProcessor4List);
        return rsLst;
    }

    @Override
    public Map getMultiMap(String dbIdentifier, String strSQL, List lstConditions) {
        Map rsLst = this.executeQueryForUpdate(dbIdentifier, strSQL, lstConditions, this.rsProcessor4Map);
        return rsLst;
    }

    @Override
    public Map getMultiObject(String dbIdentifier, String strSQL, List lstConditions, Class dataObjectClass) {
        this.rsProcessor4Object.setDataObjectClass(dataObjectClass);
        Map rsLst = this.executeQueryForUpdate(dbIdentifier, strSQL, lstConditions, this.rsProcessor4Object);
        return rsLst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map executeQueryForUpdate(String dbIdentifier, String strSQL, List lstConditions, ResultSetProcessor resultSetProcessor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isSameNumber = this.checkQuestionNumber(strSQL, lstConditions);
        if (!isSameNumber && logger.isDebugEnabled()) {
            logger.debug("Not compared SQL and parameters's number.");
        }
        List rsLst = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            strSQL = this.parseHzSql(dbIdentifier, strSQL);
            conn = ExeQueryForUpdate.getConnection(dbIdentifier);
            boolean autoComm = conn.getAutoCommit();
            result.put(CONN_KEY, conn);
            result.put(COMMIT_TYPE, autoComm);
            conn.setAutoCommit(false);
            pstmt = conn.prepareStatement(strSQL);
            if (pstmt == null) {
                logger.error("The 'pstmt' PreparedStatement is null.");
            }
            this.setParameters((PreparedStatement)pstmt, lstConditions);
            rs = pstmt.executeQuery();
            if (this.existedXlob(rs)) {
                XlobProcessor xlobProcessor = ExeQueryForUpdate.getLobProcessorClass(dbIdentifier);
                rsLst = resultSetProcessor.getResultSet(rs, xlobProcessor);
            } else {
                rsLst = resultSetProcessor.getResultSet(rs);
            }
            result.put(RESULT_LIST, rsLst);
        }
        catch (InvalidIdentifierException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            logger.error("\r\u4ea7\u751fSQL\u5f02\u5e38\uff0csql: " + strSQL);
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.error("\r\u4ea7\u751f\u5f02\u5e38\uff0csql: " + strSQL);
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqlEx) {
                    sqlEx.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sqlEx) {
                    sqlEx.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (rsLst == null) {
                ExeQueryForUpdate.releaseDbResource(conn, pstmt, rs);
                logger.error("\u4ea7\u751f\u5f02\u5e38\uff0c\u8bf7\u6839\u636e\u5f02\u5e38\u4fe1\u606f\u67e5\u627e\u539f\u56e0\u3002");
            }
        }
        return result;
    }

    private boolean existedXlob(ResultSet rs) throws SQLException {
        boolean flag = false;
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        int i = 0;
        int columnIdx = 1;
        while (i < columnCount) {
            int columnType = rsmd.getColumnType(columnIdx);
            if (columnType == 2005) {
                flag = true;
                break;
            }
            ++i;
            ++columnIdx;
        }
        return flag;
    }

    private String getCompletedSql(String tableName, String fieldName, String condition) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select ").append(fieldName);
        sbSql.append(" from ").append(tableName);
        if (condition.toLowerCase().trim().startsWith("where")) {
            sbSql.append(" ").append(condition);
        } else {
            sbSql.append(" where ").append(condition);
        }
        String strSQL = sbSql.toString();
        return strSQL;
    }

    private String getCountSQL(String strSQL) {
        String strSQL2 = strSQL.replaceAll("\\s+", " ").trim();
        String regx = "select count\\s*\\(\\s*(\\*|\\w+|\\w+\\.\\*|\\w+\\.\\w+)\\s*\\)\\s+from\\s+";
        Pattern pt = Pattern.compile(regx, 2);
        Matcher mc = pt.matcher(strSQL2);
        if (mc.find() && mc.start() == 0) {
            return strSQL;
        }
        String reg2 = " order by ";
        Pattern ptOrderNo = Pattern.compile(reg2, 2);
        Matcher mOrderNo = ptOrderNo.matcher(strSQL2);
        int indexOrderNo = -1;
        while (mOrderNo.find()) {
            indexOrderNo = mOrderNo.start();
        }
        if (indexOrderNo > 0) {
            strSQL = strSQL2 = strSQL2.substring(0, indexOrderNo);
        }
        StringBuffer sqlbuf = new StringBuffer(strSQL.length() + 30);
        sqlbuf.append("select count(*) from (");
        sqlbuf.append(strSQL);
        sqlbuf.append(") a");
        strSQL = sqlbuf.toString();
        return strSQL;
    }
}

