/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db;

import java.io.Serializable;
import java.net.InetAddress;

public class UUIDGenerator {
    private static final int IP;
    private static short counter;
    private static final int JVM;
    private static final String LONG_FORMAT = "00000000";
    private static final String SHORT_FORMAT = "0000";
    private static final int LONG_FORMAT_LENGTH;
    private static final int SHORT_FORMAT_LENGTH;
    private static String IP_FORMATED;
    private static String JVM_FORMATED;

    public UUIDGenerator() {
        if (IP_FORMATED == null) {
            IP_FORMATED = this.format(this.getIP());
            JVM_FORMATED = this.format(this.getJVM());
            IP_FORMATED = "HZ" + IP_FORMATED.substring(2);
        }
    }

    private static int IptoInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    protected int getJVM() {
        return JVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getCount() {
        Class<UUIDGenerator> clazz = UUIDGenerator.class;
        synchronized (UUIDGenerator.class) {
            if (counter < 0) {
                counter = 0;
            }
            short s = counter;
            counter = (short)(s + 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s;
        }
    }

    protected int getIP() {
        return IP;
    }

    protected short getHiTime() {
        return (short)(System.currentTimeMillis() >>> 32);
    }

    protected int getLoTime() {
        return (int)System.currentTimeMillis();
    }

    protected String format(int intval) {
        String formatted = Integer.toHexString(intval);
        StringBuffer buf = new StringBuffer(LONG_FORMAT);
        buf.replace(LONG_FORMAT_LENGTH - formatted.length(), LONG_FORMAT_LENGTH, formatted);
        return buf.toString();
    }

    protected String format(short shortval) {
        String formatted = Integer.toHexString(shortval);
        StringBuffer buf = new StringBuffer(SHORT_FORMAT);
        buf.replace(SHORT_FORMAT_LENGTH - formatted.length(), SHORT_FORMAT_LENGTH, formatted);
        return buf.toString();
    }

    public Serializable generate() {
        return new StringBuffer(36).append(IP_FORMATED).append(JVM_FORMATED).append(this.format(this.getHiTime())).append(this.format(this.getLoTime())).append(this.format(this.getCount())).toString();
    }

    public String toString() {
        return (String)((Object)this.generate());
    }

    static {
        int ipadd;
        counter = 0;
        JVM = (int)(System.currentTimeMillis() >>> 8);
        LONG_FORMAT_LENGTH = LONG_FORMAT.length();
        SHORT_FORMAT_LENGTH = SHORT_FORMAT.length();
        try {
            ipadd = UUIDGenerator.IptoInt(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception ex) {
            System.err.println("\u83b7\u5f97IP\u5730\u5740\u5b57\u8282\u6570\u7ec4\u65f6\u53d1\u751f\u5f02\u5e38\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a");
            ex.printStackTrace();
            ipadd = 0;
        }
        IP = ipadd;
    }
}

