/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db;

import com.horizon.db.Access;
import com.horizon.db.access.IExeQuery;
import com.horizon.db.access.IExeQueryForUpdate;
import com.horizon.db.access.IExeUpdate;
import com.horizon.db.access.IExeUpdateForQuery;
import com.horizon.db.access.IObject2Database;
import com.horizon.db.access.def.ExeQuery;
import com.horizon.db.access.def.ExeQueryForUpdate;
import com.horizon.db.access.def.ExeUpdate;
import com.horizon.db.access.def.ExeUpdateForQuery;
import com.horizon.db.access.def.Object2Database;
import com.horizon.exception.extend.DBException;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBOperatorProxy
implements Observer {
    private static Logger LOGGER = LoggerFactory.getLogger(DBOperatorProxy.class);
    private static DBOperatorProxy instance;
    private IExeQuery baseExeQuery = new ExeQuery();
    private IExeUpdate baseExeUpdate = new ExeUpdate();
    private IObject2Database baseObject2Database = new Object2Database();
    private IExeUpdateForQuery baseExeUpdateForQuery;
    private IExeQueryForUpdate baseExeQueryforUpdate = new ExeQueryForUpdate();
    private Map targetAccessMap;

    public void setTargetAccessMap(Map targetAccessMap) {
        this.targetAccessMap = targetAccessMap;
        this.init(this.targetAccessMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBOperatorProxy getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<DBOperatorProxy> clazz = DBOperatorProxy.class;
        synchronized (DBOperatorProxy.class) {
            if (instance == null) {
                instance = new DBOperatorProxy();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private DBOperatorProxy() {
        this.baseExeUpdateForQuery = new ExeUpdateForQuery();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof Map) {
            Map m = (Map)arg;
            this.init(m);
        }
    }

    private void init(Map map) {
        String classNameQuery = (String)map.get("query");
        String classNameUpdate = (String)map.get("update");
        String classNameSaveObject = (String)map.get("saveobject");
        if (classNameQuery != null && !ExeQuery.class.getName().equals(classNameQuery)) {
            this.baseExeQuery = (IExeQuery)this.newInstance(classNameQuery);
        }
        if (classNameUpdate != null && !ExeUpdate.class.getName().equals(classNameUpdate)) {
            this.baseExeUpdate = (IExeUpdate)this.newInstance(classNameUpdate);
        }
        if (classNameSaveObject != null && !Object2Database.class.getName().equals(classNameSaveObject)) {
            this.baseObject2Database = (IObject2Database)this.newInstance(classNameSaveObject);
        }
        Access.setDBOperator(this.baseExeQuery);
        Access.setDBOperator(this.baseExeUpdate);
        Access.setDBOperator(this.baseObject2Database);
    }

    private Object newInstance(String className) {
        try {
            Object obj = Class.forName(className).newInstance();
            return obj;
        }
        catch (InstantiationException e) {
            LOGGER.error("Occured exception when create instance, className: " + className);
            throw new DBException(e, "", "");
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Occured exception when create instance, className: " + className);
            throw new DBException(e, "", "");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Occured exception when create instance, className: " + className);
            throw new DBException(e, "", "");
        }
    }
}

