/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.db;

import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Sets;
import com.horizon.db.DBConfigInfoHelper;
import com.horizon.db.UUIDGenerator;
import com.horizon.db.access.IExeQuery;
import com.horizon.db.access.IExeQueryForUpdate;
import com.horizon.db.access.IExeUpdate;
import com.horizon.db.access.IExeUpdateForQuery;
import com.horizon.db.access.IObject2Database;
import com.horizon.db.access.def.ExeQuery;
import com.horizon.db.module.Pages;
import com.horizon.exception.HorizonException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Access {
    private static UUIDGenerator uuidGenerator = new UUIDGenerator();
    private static String DatabaseIdentifier;
    private static IExeQuery exeQuery;
    private static IExeUpdate exeUpdate;
    private static IObject2Database object2Database;
    private static IExeUpdateForQuery exeUpdateForQuery;
    private static IExeQueryForUpdate exeQueryForUpdate;

    public static String getUUID() {
        return uuidGenerator.toString();
    }

    public static boolean executeUpdate(Map<String, ? extends Collection<?>> mapSqlParameters) {
        return Access.executeUpdate(mapSqlParameters, Access.getDefDbIdentifier());
    }

    public static boolean executeUpdate(Map<String, ? extends Collection<?>> mapSqlParameters, String dbIdentifier) {
        return exeUpdate.executeUpdate(dbIdentifier, mapSqlParameters);
    }

    public static boolean executeUpdate(String sql, List lstParameters) {
        return Access.executeUpdate(sql, lstParameters, Access.getDefDbIdentifier());
    }

    public static boolean executeUpdate(String sql, List lstParameters, String dbIdentifier) {
        return exeUpdate.executeUpdate(dbIdentifier, sql, lstParameters);
    }

    public static boolean executeMultiUpdate(Map<String, ? extends Collection<?>> mapSqlParameters) {
        return Access.executeMultiUpdate(mapSqlParameters, Access.getDefDbIdentifier());
    }

    public static boolean executeMultiUpdate(Map<String, ? extends Collection<?>> mapSqlParameters, String dbIdentifier) {
        return exeUpdate.executeMultiUpdate(dbIdentifier, mapSqlParameters);
    }

    public static boolean saveClob(String tableName, String columnName, List lstParameters) {
        return Access.saveClob(tableName, columnName, lstParameters, Access.getDefDbIdentifier());
    }

    public static boolean saveClob(String tableName, String columnName, List lstParameters, String dbIdentifier) {
        return exeUpdate.updateClob(dbIdentifier, tableName, columnName, lstParameters);
    }

    public static boolean updateBlob(String tableName, String columnName, InputStream inputStream, String idValue) {
        String dbIdentifier = Access.getDefDbIdentifier();
        return Access.updateBlob(tableName, columnName, inputStream, idValue, dbIdentifier);
    }

    public static boolean updateBlob(String tableName, String columnName, InputStream inputStream, String idValue, String dbIdentifier) {
        return exeUpdate.updateBlob(dbIdentifier, tableName, columnName, inputStream, idValue);
    }

    public static boolean saveObjectData(Map<String, ? extends Object> mapTableNameAndDataObjects) {
        return Access.saveObjectData(mapTableNameAndDataObjects, Access.getDefDbIdentifier());
    }

    public static boolean saveObjectData(Map<String, ? extends Object> mapTableNameAndDataObjects, String dbIdentifier) {
        return object2Database.saveObjectData(dbIdentifier, mapTableNameAndDataObjects);
    }

    public static List getSingleList(String sql, List lstConditions) {
        return Access.getSingleList(sql, lstConditions, Access.getDefDbIdentifier());
    }

    public static List getSingleList(String sql, List lstConditions, String dbIdentifier) {
        List mutList = Access.getMultiList(sql, lstConditions, dbIdentifier);
        List sigList = null;
        if (mutList != null && !mutList.isEmpty()) {
            sigList = (List)mutList.get(0);
            mutList.clear();
        } else {
            sigList = new ArrayList(0);
        }
        return sigList;
    }

    public static List getMultiList(String sql, List lstConditions) {
        return Access.getMultiList(sql, lstConditions, Access.getDefDbIdentifier());
    }

    public static List getMultiList(String sql, List lstConditions, String dbIdentifier) {
        return exeQuery.getMultiList(dbIdentifier, sql, lstConditions);
    }

    public static List getPagingList(String sql, List lstConditions, Pages pages) {
        return Access.getPagingList(sql, lstConditions, pages.getPage(), pages.getPageSize());
    }

    public static List getPagingList(String sql, List lstConditions, Pages pages, String dbIdentifier) {
        return Access.getPagingList(sql, lstConditions, pages.getPage(), pages.getPageSize(), dbIdentifier);
    }

    public static List getPagingList(String sql, List lstConditions, int iPageNum, int iPageSize) {
        return Access.getPagingList(sql, lstConditions, iPageNum, iPageSize, Access.getDefDbIdentifier());
    }

    public static List getPagingList(String sql, List lstConditions, int iPageNum, int iPageSize, String dbIdentifier) {
        return exeQuery.getPagingList(dbIdentifier, sql, lstConditions, iPageNum, iPageSize);
    }

    public static Map getSingleMap(String sql, List lstConditions) {
        return Access.getSingleMap(sql, lstConditions, Access.getDefDbIdentifier());
    }

    public static Map getSingleMap(String sql, List lstConditions, String dbIdentifier) {
        List mutList = Access.getMultiMap(sql, lstConditions, dbIdentifier);
        Map sigMap = null;
        if (mutList != null && !mutList.isEmpty()) {
            sigMap = (Map)mutList.get(0);
            mutList.clear();
        }
        return sigMap;
    }

    public static List getMultiMap(String sql, List lstConditions) {
        return Access.getMultiMap(sql, lstConditions, Access.getDefDbIdentifier());
    }

    public static List getMultiMap(String sql, List lstConditions, String dbIdentifier) {
        return exeQuery.getMultiMap(dbIdentifier, sql, lstConditions);
    }

    public static List getPagingMap(String sql, List lstConditions, Pages pages) {
        return Access.getPagingMap(sql, lstConditions, pages.getPage(), pages.getPageSize());
    }

    public static List getPagingMap(String sql, List lstConditions, Pages pages, String dbIdentifier) {
        return Access.getPagingMap(sql, lstConditions, pages.getPage(), pages.getPageSize(), dbIdentifier);
    }

    public static List getPagingMap(String sql, List lstConditions, int iPageNum, int iPageSize) {
        return Access.getPagingMap(sql, lstConditions, iPageNum, iPageSize, Access.getDefDbIdentifier());
    }

    public static List getPagingMap(String sql, List lstConditions, int iPageNum, int iPageSize, String dbIdentifier) {
        return exeQuery.getPagingMap(dbIdentifier, sql, lstConditions, iPageNum, iPageSize);
    }

    public static <T> T getSingleObject(String sql, List<? extends Object> lstConditions, Class<T> dataObjectClass) {
        return Access.getSingleObject(sql, lstConditions, dataObjectClass, Access.getDefDbIdentifier());
    }

    public static <T> T getSingleObject(String sql, List<? extends Object> lstConditions, Class<T> dataObjectClass, String dbIdentifier) {
        List<T> mutList = Access.getMultiObject(sql, lstConditions, dataObjectClass, dbIdentifier);
        T t = null;
        if (mutList != null && !mutList.isEmpty()) {
            t = mutList.get(0);
            mutList.clear();
        }
        return t;
    }

    public static <T> List<T> getMultiObject(String sql, List<? extends Object> lstConditions, Class<T> dataObjectClass) {
        return Access.getMultiObject(sql, lstConditions, dataObjectClass, Access.getDefDbIdentifier());
    }

    public static <T> List<T> getMultiObject(String sql, List<? extends Object> lstConditions, Class<T> dataObjectClass, String dbIdentifier) {
        return exeQuery.getMultiObject(dbIdentifier, sql, lstConditions, dataObjectClass);
    }

    public static List getPagingObject(String sql, List lstConditions, Pages pages, Class dataObjectClass) {
        return Access.getPagingObject(sql, lstConditions, pages.getPage(), pages.getPageSize(), dataObjectClass);
    }

    public static List getPagingObject(String sql, List lstConditions, Pages pages, Class dataObjectClass, String dbIdentifier) {
        return Access.getPagingObject(sql, lstConditions, pages.getPage(), pages.getPageSize(), dataObjectClass, dbIdentifier);
    }

    public static List getPagingObject(String sql, List lstConditions, int iPageNum, int iPageSize, Class dataObjectClass) {
        return Access.getPagingObject(sql, lstConditions, iPageNum, iPageSize, dataObjectClass, Access.getDefDbIdentifier());
    }

    public static List getPagingObject(String sql, List lstConditions, int iPageNum, int iPageSize, Class dataObjectClass, String dbIdentifier) {
        return exeQuery.getPagingObject(dbIdentifier, sql, lstConditions, dataObjectClass, iPageNum, iPageSize);
    }

    public static int getRsCount(String sql, List lstConditions) {
        return Access.getRsCount(sql, lstConditions, Access.getDefDbIdentifier());
    }

    public static int getRsCount(String sql, List lstConditions, String dbIdentifier) {
        return exeQuery.getRsCount(dbIdentifier, sql, lstConditions);
    }

    public static String getClobContent(String tableName, String fieldName, String condition) {
        String dbIdentifier = Access.getDefDbIdentifier();
        return exeQuery.getClobContent(dbIdentifier, tableName, fieldName, condition);
    }

    public static String getClobContent(String tableName, String fieldName, String condition, String dbIdentifier) {
        return exeQuery.getClobContent(dbIdentifier, tableName, fieldName, condition);
    }

    public static String getBlobContent(String tableName, String fieldName, String condition) {
        String dbIdentifier = Access.getDefDbIdentifier();
        String rs = Access.getBlobContent(tableName, fieldName, condition, dbIdentifier);
        return rs;
    }

    public static String getBlobContent(String tableName, String fieldName, String condition, String dbIdentifier) {
        byte[] blobContent = Access.getBlobContentBytes(tableName, fieldName, condition, dbIdentifier);
        if (blobContent == null) {
            return "";
        }
        String rs = new String(blobContent);
        return rs;
    }

    public static byte[] getBlobContentBytes(String tableName, String fieldName, String condition) {
        String dbIdentifier = Access.getDefDbIdentifier();
        byte[] blobContent = Access.getBlobContentBytes(tableName, fieldName, condition, dbIdentifier);
        return blobContent;
    }

    public static byte[] getBlobContentBytes(String tableName, String fieldName, String condition, String dbIdentifier) {
        byte[] blobContent = exeQuery.getBlobContent(dbIdentifier, tableName, fieldName, condition);
        return blobContent;
    }

    public static Map getTableColumnMsg(String tableName) {
        return Access.getTableColumnMsg(tableName, true);
    }

    public static Map getTableColumnMsg(String tableName, boolean isToLowerCase) {
        return Access.getTableColumnMsg(tableName, isToLowerCase, Access.getDefDbIdentifier());
    }

    public static Map getTableColumnMsg(String tableName, boolean isToLowerCase, String dbIdentifier) {
        return exeQuery.getColumnMsg(dbIdentifier, tableName, isToLowerCase);
    }

    public static Map getColumnBySql(String sql, boolean isToLowerCase, String dbIdentifier) {
        return exeQuery.getColumnBySql(sql, isToLowerCase, dbIdentifier);
    }

    public static List getTableNames() {
        return Access.getTableNames(Access.getDefDbIdentifier());
    }

    public static List getTableNamesUpperCase() {
        ArrayList result = Lists.newArrayList();
        List list = Access.getTableNames(Access.getDefDbIdentifier());
        if (list != null && !list.isEmpty()) {
            for (String table : list) {
                result.add(table.toUpperCase());
            }
        }
        return result;
    }

    public static List getTableNames(String dbIdentifier) {
        List lst = exeQuery.getTableNames(dbIdentifier);
        return lst;
    }

    public static List getTableNamesUpperCase(String dbIdentifier) {
        ArrayList result = Lists.newArrayList();
        List list = Access.getTableNames(dbIdentifier);
        if (list != null && !list.isEmpty()) {
            for (String table : list) {
                result.add(table.toUpperCase());
            }
        }
        return result;
    }

    private static String getDefDbIdentifier() {
        String dbIdentifier = DatabaseIdentifier;
        if (dbIdentifier == null || dbIdentifier.length() == 0) {
            dbIdentifier = DBConfigInfoHelper.getDefaultDatabaseIdentifier();
        }
        return dbIdentifier;
    }

    public static void setDatabaseIdentifier(String identifier) {
        DatabaseIdentifier = identifier;
    }

    static void setDBOperator(IExeQuery exeQuery) {
        Access.exeQuery = exeQuery;
    }

    static void setDBOperator(IExeUpdate exeUpdate) {
        Access.exeUpdate = exeUpdate;
    }

    static void setDBOperator(IObject2Database object2Database) {
        Access.object2Database = object2Database;
    }

    static void setDBOperator(IExeQueryForUpdate exeQueryForUpdate) {
        Access.exeQueryForUpdate = exeQueryForUpdate;
    }

    static void setDBOperator(IExeUpdateForQuery exeUpdateForQuery) {
        Access.exeUpdateForQuery = exeUpdateForQuery;
    }

    public static Map getMultiObjectForUpdate(String sql, List lstConditions, Class dataObjectClass, String dbIdentifier) {
        return exeQueryForUpdate.getMultiObject(dbIdentifier, sql, lstConditions, dataObjectClass);
    }

    public static boolean executeMultiUpdateForQuery(LinkedHashMap mapSqlParameters, String dbIdentifier, Connection conn, boolean autoComm) {
        return exeUpdateForQuery.executeMultiUpdateForQuery(dbIdentifier, mapSqlParameters, conn, autoComm);
    }

    public static List<String> getPrimaryKeys(String dbIdentifier, String tableName) {
        ArrayList primarykeyList;
        Connection connection = ExeQuery.getConnection(dbIdentifier);
        HashSet primaryKeySets = Sets.newHashSet();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet primaryKeys = metaData.getPrimaryKeys(null, null, tableName);
            while (primaryKeys.next()) {
                String column_name = primaryKeys.getString("COLUMN_NAME");
                primaryKeySets.add(column_name);
            }
            primarykeyList = Lists.newArrayList((Iterable)primaryKeySets);
        }
        catch (SQLException e) {
            throw new HorizonException(e.getMessage());
        }
        return primarykeyList;
    }

    public static List<String> getPrimaryKeys(String tableName) {
        return Access.getPrimaryKeys(Access.getDefDbIdentifier(), tableName);
    }
}

