/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.datasource.registry;

import com.horizon.datasource.config.DatabaseConnectionInfo;
import com.horizon.datasource.registry.BaseDataSourceRegistry;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JndiDataSourceRegistry
extends BaseDataSourceRegistry {
    private DatabaseConnectionInfo databaseInfo;

    @Override
    public void setDatabaseInfo(DatabaseConnectionInfo databaseInfo) {
        this.databaseInfo = databaseInfo;
    }

    @Override
    protected DataSource createDataSourceForTenant() {
        String dataSourceName = this.databaseInfo.getJndiName();
        NamingException nEx = null;
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            Context envCtx = (Context)ctx.lookup("java:/comp/env");
            DataSource dataSource = (DataSource)envCtx.lookup(dataSourceName);
            return dataSource;
        }
        catch (NamingException nEx1) {
            nEx = nEx1;
            try {
                if (ctx == null) {
                    ctx = new InitialContext();
                }
                DataSource dataSource = (DataSource)ctx.lookup(dataSourceName);
                return dataSource;
            }
            catch (NamingException nEx2) {
                nEx = nEx2;
                try {
                    if (ctx == null) {
                        ctx = new InitialContext();
                    }
                    DataSource dataSource = (DataSource)ctx.lookup("java:/comp/env/" + dataSourceName);
                    return dataSource;
                }
                catch (NamingException nEx3) {
                    nEx = nEx3;
                    String msg = "Can't get the DataSource object by dataSourceName: " + dataSourceName;
                    int lineNumber = 113;
                    this.showFormatedErrorInfo("generateDataSource", lineNumber, msg);
                    if (nEx != null) {
                        nEx.printStackTrace();
                    }
                    return null;
                }
            }
        }
    }

    private void showFormatedErrorInfo(String methodName, int lineNumber, String msg) {
        String infoType = "ERROR";
        this.showFormatedInfo(methodName, lineNumber, msg, infoType);
    }

    private void showFormatedInfo(String methodName, int lineNumber, String msg, String infoType) {
        String fullClassName = this.getClass().getName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HH:mm:ss,SSS");
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(df.format(new Date()));
        sb.append(" ").append(infoType).append("] ");
        sb.append(fullClassName);
        sb.append(".").append(methodName).append("(");
        sb.append(className).append(".java:").append(lineNumber);
        sb.append(") - ").append(msg);
        String info = sb.toString();
        System.out.println(info);
    }
}

