/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.datasource.registry;

import com.horizon.datasource.DynamicDataSource;
import com.horizon.datasource.config.DatabaseConnectionInfo;
import com.horizon.datasource.registry.BaseDataSourceRegistry;
import com.horizon.datasource.registry.DataSourceRegistry;
import com.horizon.db.DBConfigInfoHelper;

public enum DataSourceRegistryFactory {
    INSTANCE;

    private DynamicDataSource dynamicDataSource;

    public DataSourceRegistry getDataSourceRegistry() {
        DataSourceRegistry returnDataSourceRegistry = BaseDataSourceRegistry.getInstace();
        return returnDataSourceRegistry;
    }

    public void createDataSourceRegistry(DatabaseConnectionInfo databaseInfo) {
        String identifier = databaseInfo.getIdentifier();
        DataSourceRegistry dataSourceRegistry = BaseDataSourceRegistry.getInstace(databaseInfo);
        String dbIdentifier = DBConfigInfoHelper.getDefaultDatabaseIdentifier();
        dataSourceRegistry.registerSingleDataSource(identifier);
        if (dbIdentifier.equals(identifier)) {
            this.dynamicDataSource.setDefaultTargetDataSource(dataSourceRegistry.getDataSourceOfTenant(dbIdentifier));
        }
        this.dynamicDataSource.restDataSource();
    }

    public void setDynamicDataSource(DynamicDataSource dynamicDataSource) {
        this.dynamicDataSource = dynamicDataSource;
    }
}

