/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.datasource.registry;

import com.horizon.datasource.config.DatabaseConnectionInfo;
import com.horizon.datasource.config.impl.DatabaseConnectionInfoImpl;
import com.horizon.datasource.registry.DataSourceRegistry;
import com.horizon.datasource.registry.JdbcDataSourceRegistry;
import com.horizon.datasource.registry.JndiDataSourceRegistry;
import com.horizon.db.xconnection.provider.ConnectionProviderFactory;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

abstract class BaseDataSourceRegistry
implements DataSourceRegistry {
    private static final String CONNECTION_TYPE_JNDI = "jndi";
    private static final String CONNECTION_TYPE_JDBC = "jdbc";
    private static Map<String, DataSource> dataSources;

    BaseDataSourceRegistry() {
    }

    public abstract void setDatabaseInfo(DatabaseConnectionInfo var1);

    @Override
    public DataSource getDataSourceOfTenant(String tenant) {
        return dataSources.get(tenant);
    }

    protected abstract DataSource createDataSourceForTenant();

    @Override
    public synchronized void registerDataSources(Map<String, DataSource> mapDataSources) {
        dataSources = mapDataSources;
    }

    @Override
    public synchronized void registerSingleDataSource(String tenant) {
        DataSource dataSource;
        if (dataSources == null) {
            dataSources = new HashMap<String, DataSource>();
        }
        if ((dataSource = this.createDataSourceForTenant()) != null) {
            dataSources.put(tenant, this.createDataSourceForTenant());
        }
    }

    @Override
    public synchronized void unregisterSingleDataSource(String tenant) {
        DataSource dataSource = dataSources.remove(tenant);
        if (dataSource != null) {
            dataSource = null;
            ConnectionProviderFactory.getInstance().distoryDatabaseInfo(tenant);
        }
    }

    @Override
    public synchronized void releaseAllDataSources() {
        dataSources.clear();
    }

    @Override
    public int size() {
        return dataSources.size();
    }

    @Override
    public boolean existsDataSourceOfTenant(String tenant) {
        return dataSources.containsKey(tenant);
    }

    public static DataSourceRegistry getInstace() {
        DatabaseConnectionInfoImpl databaseInfo = new DatabaseConnectionInfoImpl();
        databaseInfo.setConnectionType(CONNECTION_TYPE_JDBC);
        return BaseDataSourceRegistry.getInstace(databaseInfo);
    }

    public static DataSourceRegistry getInstace(DatabaseConnectionInfo databaseInfo) {
        BaseDataSourceRegistry registry = null;
        String connectionType = databaseInfo.getConnectionType();
        registry = CONNECTION_TYPE_JNDI.equalsIgnoreCase(connectionType) ? new JndiDataSourceRegistry() : new JdbcDataSourceRegistry();
        registry.setDatabaseInfo(databaseInfo);
        return registry;
    }
}

