/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.datasource.creator;

import com.horizon.datasource.creator.AbstractDataSourceCreator;
import com.horizon.profile.AppConfig;
import com.horizon.utils.StringUtil;
import org.apache.tomcat.jdbc.pool.DataSource;

public class TomcatJdbcDataSourceCreator
extends AbstractDataSourceCreator {
    @Override
    protected javax.sql.DataSource createDataSource() {
        DataSource dataSource = new DataSource();
        String validation = AppConfig.get("dbconfig", "horizon.db.validationQuery");
        if (StringUtil.hasValue(validation)) {
            dataSource.setValidationQuery(validation);
        }
        dataSource.setTestWhileIdle(true);
        dataSource.setTimeBetweenEvictionRunsMillis(5000);
        dataSource.setRemoveAbandoned(true);
        dataSource.setRemoveAbandonedTimeout(this.connectionInfo.getMaxIdelTime());
        String connectionProperties = this.connectionInfo.getConnectionProperties();
        if (StringUtil.hasValue(connectionProperties)) {
            dataSource.setConnectionProperties(connectionProperties);
        }
        dataSource.setRemoveAbandonedTimeout(this.connectionInfo.getMaxIdelTime());
        return dataSource;
    }

    @Override
    protected String getDriverClassPropName() {
        return "driverClassName";
    }

    @Override
    protected String getUrlPropName() {
        return "url";
    }

    @Override
    protected String getUsernamePropName() {
        return "username";
    }

    @Override
    protected String getPasswordPropName() {
        return "password";
    }

    @Override
    protected String getMaxPoolSize() {
        return "maxActive";
    }

    @Override
    protected String getMinPoolSize() {
        return "minIdle";
    }

    @Override
    protected String getInitialPoolSize() {
        return "initialSize";
    }

    @Override
    protected String getMaxIdelTime() {
        return "maxWait";
    }

    @Override
    protected String getConnectionProperties() {
        return "connectionProperties";
    }
}

