/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.datasource.creator;

import com.alibaba.druid.pool.DruidDataSource;
import com.horizon.datasource.creator.AbstractDataSourceCreator;
import com.horizon.profile.AppConfig;
import com.horizon.utils.StringUtil;
import javax.sql.DataSource;

public class DruidJdbcDataSourceCreator
extends AbstractDataSourceCreator {
    @Override
    protected DataSource createDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        String validation = AppConfig.get("dbconfig", "horizon.db.validationQuery");
        if (StringUtil.hasValue(validation)) {
            dataSource.setValidationQuery(validation);
        }
        dataSource.setTestWhileIdle(true);
        dataSource.setTimeBetweenEvictionRunsMillis(5000L);
        String connectionProperties = this.connectionInfo.getConnectionProperties();
        if (StringUtil.hasValue(validation)) {
            dataSource.setConnectionProperties(connectionProperties);
        }
        return dataSource;
    }

    @Override
    protected String getDriverClassPropName() {
        return "driverClassName";
    }

    @Override
    protected String getUrlPropName() {
        return "url";
    }

    @Override
    protected String getUsernamePropName() {
        return "username";
    }

    @Override
    protected String getPasswordPropName() {
        return "password";
    }

    @Override
    protected String getMaxPoolSize() {
        return "maxActive";
    }

    @Override
    protected String getMinPoolSize() {
        return "minIdle";
    }

    @Override
    protected String getInitialPoolSize() {
        return "initialSize";
    }

    @Override
    protected String getMaxIdelTime() {
        return "maxWait";
    }

    @Override
    protected String getConnectionProperties() {
        return "connectionProperties";
    }
}

