/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.datasource.creator;

import com.horizon.datasource.config.DatabaseConnectionInfo;
import com.horizon.datasource.creator.DataSourceCreator;
import com.horizon.exception.extend.DBException;
import java.lang.reflect.InvocationTargetException;
import javax.sql.DataSource;
import org.apache.commons.beanutils.BeanUtils;

public abstract class AbstractDataSourceCreator
implements DataSourceCreator {
    protected DatabaseConnectionInfo connectionInfo;

    @Override
    public DataSource createDataSourceForTenant() {
        DataSource result = this.createDataSource();
        this.setProperty(result, this.getDriverClassPropName(), this.connectionInfo.getDriverClass());
        this.setProperty(result, this.getUrlPropName(), this.connectionInfo.getUrl());
        this.setProperty(result, this.getUsernamePropName(), this.connectionInfo.getUserName());
        this.setProperty(result, this.getPasswordPropName(), this.connectionInfo.getUserPassword());
        this.setProperty(result, this.getInitialPoolSize(), this.connectionInfo.getInitialPoolSize());
        this.setProperty(result, this.getMaxPoolSize(), this.connectionInfo.getMaxPoolSize());
        this.setProperty(result, this.getMinPoolSize(), this.connectionInfo.getMinPoolSize());
        this.setProperty(result, this.getMaxIdelTime(), this.connectionInfo.getMaxIdelTime());
        this.setProperty(result, this.getConnectionProperties(), this.connectionInfo.getConnectionProperties());
        return result;
    }

    @Override
    public void setDatabaseConnectionInfo(DatabaseConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    protected abstract DataSource createDataSource();

    protected abstract String getDriverClassPropName();

    protected abstract String getUrlPropName();

    protected abstract String getUsernamePropName();

    protected abstract String getPasswordPropName();

    protected abstract String getMaxPoolSize();

    protected abstract String getMinPoolSize();

    protected abstract String getInitialPoolSize();

    protected abstract String getMaxIdelTime();

    protected abstract String getConnectionProperties();

    private void setProperty(Object obj, String propName, Object propValue) {
        try {
            BeanUtils.setProperty((Object)obj, (String)propName, (Object)propValue);
        }
        catch (IllegalAccessException e) {
            throw new DBException(e, "Datasource property setting failed");
        }
        catch (InvocationTargetException e) {
            throw new DBException(e, "Datasource property setting failed");
        }
    }
}

