/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.datasource;

import com.horizon.datasource.config.DatabaseConnectionInfo;
import com.horizon.datasource.registry.DataSourceRegistry;
import com.horizon.datasource.registry.DataSourceRegistryFactory;
import com.horizon.datasource.util.DataSourceContextHolder;
import com.horizon.db.xconnection.provider.ConnectionProviderFactory;
import java.util.Map;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private DatabaseConnectionInfo databaseConnectionInfo;
    private DatabaseConnectionInfo[] databaseConnectionInfos;

    public Object determineCurrentLookupKey() {
        return DataSourceContextHolder.getDataSourceName();
    }

    public void setDataSourceLookup(DataSourceLookup dataSourceLookup) {
        super.setDataSourceLookup(dataSourceLookup);
    }

    public void setDefaultTargetDataSource(Object defaultTargetDataSource) {
        super.setDefaultTargetDataSource(defaultTargetDataSource);
    }

    public void setTargetDataSources(Map targetDataSources) {
        super.setTargetDataSources(targetDataSources);
        super.afterPropertiesSet();
        this.registryDataSource(targetDataSources);
    }

    public void restDataSource() {
        super.afterPropertiesSet();
    }

    public void setDatabaseConnectionInfo(DatabaseConnectionInfo databaseConnectionInfo) {
        this.databaseConnectionInfo = databaseConnectionInfo;
    }

    public void setDatabaseConnectionInfos(DatabaseConnectionInfo[] databaseConnectionInfos) {
        this.databaseConnectionInfos = databaseConnectionInfos;
    }

    private void registryDataSource(Map targetDataSources) {
        DataSourceRegistryFactory.INSTANCE.setDynamicDataSource(this);
        DataSourceRegistry registry = DataSourceRegistryFactory.INSTANCE.getDataSourceRegistry();
        registry.registerDataSources(targetDataSources);
        if (this.databaseConnectionInfos != null) {
            ConnectionProviderFactory.getInstance().setDatabaseConnectionInfo(this.databaseConnectionInfos);
        } else {
            ConnectionProviderFactory.getInstance().setDatabaseConnectionInfo(this.databaseConnectionInfo);
        }
    }
}

