/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.tree;

import com.horizon.common.base.Function;
import com.horizon.common.base.Objects;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Ordering;
import com.horizon.core.common.entity.DataEntity;
import com.horizon.core.common.entity.Entity;
import com.horizon.core.common.entity.TreeEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public final class TreeNode<T extends TreeEntity>
implements Serializable {
    private T t;
    protected TreeNode<T> parent;
    private Vector<TreeNode<T>> children;

    public TreeNode() {
        this(new TreeEntity("root", "\u6839\u7ed3\u70b9"));
    }

    public TreeNode(T data) {
        this.t = data;
    }

    public void add(TreeNode<T> newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    public void insert(TreeNode<T> newChild, int childIndex) {
        if (newChild == null) {
            throw new IllegalArgumentException("\u65b0\u8282\u70b9\u4e3a null");
        }
        if (this.isNodeAncestor(newChild)) {
            throw new IllegalArgumentException("\u65b0\u8282\u70b9\u6ca1\u6709\u7236\u8282\u70b9");
        }
        TreeNode<T> oldParent = newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
        this.getOrdering().sortedCopy(this.children);
    }

    public void remove(int childIndex) {
        TreeNode<T> child = this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    public void remove(TreeNode<T> aChild) {
        if (aChild == null) {
            return;
        }
        if (!this.isNodeChild(aChild)) {
            return;
        }
        int index = this.getIndex(aChild);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public int getIndex(TreeNode<T> aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.children.indexOf(aChild);
    }

    public int getLevel() {
        int levels = 0;
        TreeNode<T> ancestor = this;
        while ((ancestor = ancestor.getParent()) != null) {
            ++levels;
        }
        return levels;
    }

    public int getChildCount() {
        int count = 0;
        if (this.children != null) {
            count = this.children.size();
        }
        return count;
    }

    public TreeNode<T> getNode(T data) {
        TreeNode<T> node = new TreeNode<T>(data);
        int index = this.children.indexOf(node);
        return index != -1 ? this.children.get(index) : null;
    }

    public TreeNode<T> getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("\u6ca1\u6709\u5b50\u8282\u70b9");
        }
        return this.children.elementAt(index);
    }

    public List<TreeNode<T>> getChildren() {
        ArrayList list = Lists.newArrayList();
        if (this.children != null) {
            list.addAll(this.children);
        }
        return list;
    }

    public List<TreeNode<T>> getAllNodes() {
        ArrayList lstNodes = Lists.newArrayList();
        Stack<TreeNode<T>> s = new Stack<TreeNode<T>>();
        s.push(this);
        while (!s.empty()) {
            TreeNode n = (TreeNode)s.pop();
            lstNodes.add(n);
            List<TreeNode<T>> children = n.getChildren();
            int iCount = children.size();
            if (n.isLeaf()) continue;
            for (int i = iCount - 1; i >= 0; --i) {
                TreeNode<T> sn = children.get(i);
                s.push(sn);
            }
        }
        return lstNodes;
    }

    public TreeNode<T>[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    public TreeNode<T>[] getPathToRoot(int level) {
        return this.getPathToRoot(this, level);
    }

    private TreeNode<T>[] getPathToRoot(TreeNode<T> node, int level) {
        TreeNode[] retNodes = new TreeNode[this.getLevel() + 1 - level];
        if (node != null && node.getLevel() >= level) {
            retNodes = this.getPathToRoot(node.getParent(), level);
            retNodes[node.getLevel() - level] = node;
        }
        return retNodes;
    }

    public List<T> getDataPath() {
        return this.getDataPathToRoot(0);
    }

    public List<T> getDataPathToRoot(int level) {
        ArrayList dataList = Lists.newArrayList();
        TreeNode<T>[] treeNodes = this.getPathToRoot(level);
        if (treeNodes != null && treeNodes.length > 0) {
            for (TreeNode<T> treeNode : treeNodes) {
                dataList.add(treeNode.getData());
            }
        }
        return dataList;
    }

    public T getData() {
        return this.t;
    }

    public List<T> getChildrenData(boolean isAllChild) {
        List<TreeNode<T>> nodes = isAllChild ? this.getAllNodes() : this.getChildren();
        return this.getData(nodes);
    }

    private List<T> getData(List<TreeNode<T>> nodes) {
        ArrayList dataList = Lists.newArrayList();
        for (TreeNode<T> n1 : nodes) {
            dataList.add(n1.getData());
        }
        return dataList;
    }

    public void setData(T t) {
        this.t = t;
    }

    public void setChildren(List<TreeNode<T>> children) {
        if (null != children && !children.isEmpty()) {
            for (TreeNode<T> newChild : children) {
                this.add(newChild);
            }
        }
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public void setParent(TreeNode<T> parent) {
        this.parent = parent;
    }

    private Ordering<TreeNode<T>> getOrdering() {
        Ordering ordering = Ordering.natural().onResultOf(new Function<TreeNode<T>, Integer>(){

            public Integer apply(TreeNode<T> treeNode) {
                Object data = treeNode.getData();
                if (data == null) {
                    return 0;
                }
                Integer orderNo = ((DataEntity)data).getOrderNo();
                return orderNo != null ? orderNo : 0;
            }
        });
        return ordering;
    }

    private boolean isNodeChild(TreeNode<T> aNode) {
        if (aNode == null) {
            throw new IllegalArgumentException("argument is null");
        }
        boolean returnValue = false;
        if (this.getChildCount() != 0) {
            returnValue = aNode.getParent() == this;
        }
        return returnValue;
    }

    private boolean isNodeAncestor(TreeNode<T> anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        TreeNode<T> ancestor = this;
        do {
            if (ancestor != anotherNode) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TreeNode)) {
            return false;
        }
        TreeNode treeNode = (TreeNode)o;
        return Objects.equal(this.getData(), treeNode.getData());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{((Entity)this.getData()).hashCode()});
    }
}

