/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.tree;

import com.horizon.common.base.Function;
import com.horizon.common.base.Objects;
import com.horizon.common.base.Predicate;
import com.horizon.common.collect.Collections2;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.common.collect.Ordering;
import com.horizon.core.common.entity.Entity;
import com.horizon.core.common.entity.TreeEntity;
import com.horizon.core.tree.TreeNode;
import com.horizon.utils.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeModel<T extends TreeEntity>
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeModel.class);
    private int children;
    private int depth;
    private static final int MAX_NODE = 50000;
    private TreeNode<T> root;
    private List<TreeNode<T>> nodes;

    public TreeModel() {
        this.nodes = Lists.newArrayList();
    }

    public TreeModel(TreeNode<T> root) {
        this.root = root;
        this.nodes = Lists.newArrayList();
        if (!root.getAllNodes().isEmpty()) {
            this.nodes.addAll(root.getAllNodes());
        } else {
            this.nodes.add(this.root);
        }
    }

    public TreeModel<T> setDepth(int depth) {
        this.depth = depth;
        return this;
    }

    public TreeModel<T> setChildren(int children) {
        this.children = children;
        return this;
    }

    public TreeModel<T> creat() {
        if (this.root == null) {
            this.root = new TreeNode();
            this.nodes.add(this.root);
        }
        this.init(this.root);
        return this;
    }

    public TreeModel<T> creat(List<T> datas) {
        if (datas == null || datas.isEmpty()) {
            return null;
        }
        LinkedHashMap dtoMap = Maps.newLinkedHashMap();
        for (TreeEntity data : datas) {
            dtoMap.put(data.getId(), new TreeNode<TreeEntity>(data));
        }
        this.buildTreeNode(dtoMap);
        return this;
    }

    private void filterRootNodes(final Map<String, TreeNode<T>> dtoMap) {
        Collection rootsTmp = Collections2.filter(dtoMap.values(), (Predicate)new Predicate<TreeNode<T>>(){

            public boolean apply(TreeNode<T> node) {
                String parentId = ((TreeEntity)node.getData()).getParentId();
                if (parentId == null || Objects.equal((Object)"root", (Object)parentId)) {
                    if (TreeModel.this.root != null) {
                        throw new RuntimeException("\u6784\u5efa\u7ed3\u6784\u6811\u5931\u8d25,\u5b58\u5728\u591a\u4e2a\u6839\u8282\u70b9");
                    }
                    TreeModel.this.root = node;
                    return true;
                }
                if (!dtoMap.containsKey(parentId)) {
                    LOGGER.warn("\u6784\u5efa\u7ed3\u6784\u6811,\u5b58\u5728\u7236\u8282\u70b9\u8bbe\u7f6e\u4f46\u672a\u627e\u5230\u7236\u8282\u70b9\u7684\u8282\u70b9");
                    return true;
                }
                return false;
            }
        });
        ArrayList roots = Lists.newArrayList(rootsTmp.iterator());
        if (roots == null || roots.isEmpty()) {
            throw new RuntimeException("\u6784\u5efa\u7ed3\u6784\u6811\u5931\u8d25,\u672a\u627e\u5230\u8ddf\u8282\u70b9");
        }
        if (this.root == null) {
            this.root = (TreeNode)roots.get(0);
        }
        this.nodes.addAll(roots);
    }

    private void filterNotRootNodes(final Map<String, TreeNode<T>> dtoMap) {
        Collection roots = Collections2.filter(dtoMap.values(), (Predicate)new Predicate<TreeNode<T>>(){

            public boolean apply(TreeNode<T> node) {
                TreeNode parent;
                if (((TreeEntity)node.getData()).getParentId() != null && (parent = (TreeNode)dtoMap.get(((TreeEntity)node.getData()).getParentId())) != null) {
                    parent.add(node);
                    node.setParent(parent);
                    return true;
                }
                return false;
            }
        });
        this.nodes.addAll(roots);
    }

    public TreeNode<T>[] getPathToRoot(TreeNode<T> aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected TreeNode<T>[] getPathToRoot(TreeNode<T> aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public boolean isLeaf(TreeNode<T> node) {
        return node.isLeaf();
    }

    public TreeNode<T> getRoot() {
        return this.root;
    }

    public TreeNode<T> getNode(String dataId) {
        TreeEntity data = new TreeEntity(dataId);
        return this.getNode(data);
    }

    public TreeNode<T> getNode(TreeEntity data) {
        TreeNode<TreeEntity> node = new TreeNode<TreeEntity>(data);
        int index = this.nodes.indexOf(node);
        return index > -1 ? this.nodes.get(index) : null;
    }

    public boolean isExist(TreeEntity data) {
        TreeNode<TreeEntity> node = new TreeNode<TreeEntity>(data);
        return this.isExits(node);
    }

    private boolean isExits(TreeNode node) {
        int index = this.nodes.indexOf(node);
        return index > -1;
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public List<T> getNodeDatas() {
        return this.getData(this.nodes);
    }

    public List<T> getNodeDatas(TreeNode<T> node) {
        List<TreeNode<T>> nodes = this.getNodes(node);
        return this.getData(nodes);
    }

    private List<T> getData(List<TreeNode<T>> nodes) {
        ArrayList list = Lists.newArrayList();
        for (TreeNode<T> n1 : nodes) {
            list.add(n1.getData());
        }
        return list;
    }

    public List<TreeNode<T>> getNodes() {
        return this.nodes;
    }

    public List<TreeNode<T>> getNodes(TreeNode<T> node) {
        if (!this.isExits(node)) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u7684\u8282\u70b9\uff0c\u5728\u5f53\u524d\u6811\u7ed3\u6784\u4e0a\u4e3a null");
        }
        TreeNode<T> oldNode = this.getTreeNode(node);
        ArrayList<TreeNode<T>> lstNodes = new ArrayList<TreeNode<T>>();
        Stack s = new Stack();
        s.push(oldNode);
        while (!s.empty()) {
            TreeNode n = (TreeNode)s.pop();
            lstNodes.add(n);
            if (n.isLeaf()) continue;
            List children = n.getChildren();
            int childCount = n.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                TreeNode sn = children.get(i);
                s.push(sn);
            }
        }
        return lstNodes;
    }

    public TreeNode<T> getTreeNode(TreeNode<T> node) {
        int idx = this.nodes.indexOf(node);
        return this.nodes.get(idx);
    }

    public void addTreeNode(TreeNode<T> newNode) {
        T data = newNode.getData();
        String parentId = ((TreeEntity)data).getParentId();
        if (this.isExits(newNode)) {
            TreeNode<T> oldNode = this.getTreeNode(newNode);
            if (Objects.equal(newNode.getParent(), oldNode.getParent())) {
                oldNode.setData(newNode.getData());
            } else {
                TreeNode<T> oldParent = oldNode.getParent();
                List<TreeNode<T>> children = oldNode.getChildren();
                TreeNode<T> newParent = this.getNode(parentId);
                if (newParent != null) {
                    newNode.setChildren(children);
                    newParent.add(newNode);
                    oldParent.remove(oldNode);
                }
            }
        } else {
            TreeNode<T> parentNode = this.getNode(parentId);
            if (parentNode != null) {
                parentNode.add(newNode);
                this.nodes.add(newNode);
            }
        }
    }

    public void removeTreeNode(TreeNode<T> node) {
        if (this.isExits(node)) {
            TreeNode<T> treeNode = this.getTreeNode(node);
            TreeNode<T> parentNode = treeNode.getParent();
            if (parentNode != null) {
                parentNode.remove(treeNode);
            }
            this.nodes.remove(treeNode);
        }
    }

    public void addSubTree(TreeModel<T> ... trees) {
        TreeNode<T> node = null;
        for (TreeModel<T> tree : trees) {
            node = tree.getRoot();
            if (node == null) continue;
            String parentId = ((Entity)this.root.getData()).getId();
            ((TreeEntity)node.getData()).setParentId(parentId);
            this.root.add(node);
            this.nodes.addAll(tree.getNodes());
        }
    }

    private void init(TreeNode<T> root) {
        for (int i = 0; i < this.children; ++i) {
            TreeNode node = new TreeNode();
            root.add(node);
            if (this.getNodeCount() > 50000 - this.children || node.getLevel() >= this.depth - 1) continue;
            this.init(node);
        }
    }

    public static void main(String[] args) {
        TreeEntity t1 = new TreeEntity("1");
        t1.setOrderNo(2);
        TreeEntity t2 = new TreeEntity("2");
        t2.setOrderNo(3);
        TreeEntity t3 = new TreeEntity("3");
        t3.setOrderNo(5);
        TreeEntity t4 = new TreeEntity("4");
        t4.setOrderNo(4);
        TreeEntity t5 = new TreeEntity("5");
        t5.setOrderNo(6);
        Vector<TreeEntity> list = new Vector<TreeEntity>();
        list.add(t1);
        list.add(t2);
        list.add(t3);
        list.add(t4);
        list.add(t5);
        list.remove(2);
        System.out.println(list);
        Ordering ordering = Ordering.natural().onResultOf((Function)new Function<TreeEntity, Integer>(){

            public Integer apply(TreeEntity entity) {
                return entity.getOrderNo();
            }
        });
        ordering.sortedCopy(list);
        for (TreeEntity treeEntity : list) {
            System.out.println(treeEntity.getOrderNo());
        }
        System.out.println(((TreeEntity)ordering.max(list)).getOrderNo());
        System.out.println(((TreeEntity)ordering.min(list)).getOrderNo());
        System.out.println(ordering.binarySearch(list, (Object)t3));
    }

    private void buildTreeNode(Map<String, TreeNode<T>> dtoMap) {
        Collection<TreeNode<T>> nodes = dtoMap.values();
        ArrayList rootNodes = Lists.newArrayList();
        ArrayList childrenNodes = Lists.newArrayList();
        for (TreeNode<T> node : nodes) {
            String parentId = ((TreeEntity)node.getData()).getParentId();
            if (StringUtil.hasValue(parentId) && dtoMap.containsKey(parentId)) {
                TreeNode<T> parent = dtoMap.get(parentId);
                parent.add(node);
                node.setParent(parent);
                childrenNodes.add(node);
            }
            if (StringUtil.hasValue(parentId) && !Objects.equal((Object)"root", (Object)parentId)) {
                if (dtoMap.containsKey(parentId)) continue;
                rootNodes.add(node);
                LOGGER.warn("\u6784\u5efa\u7ed3\u6784\u6811,\u5b58\u5728\u7236\u8282\u70b9id:{},\u4f46\u672a\u627e\u5230\u8be5\u7236\u8282\u70b9", (Object)parentId);
                continue;
            }
            if (this.root != null) {
                throw new RuntimeException("\u6784\u5efa\u7ed3\u6784\u6811\u5931\u8d25,\u5df2\u5b58\u5728\u6839\u8282\u70b9");
            }
            this.root = node;
            rootNodes.add(node);
        }
        TreeNode<T> treeNode = this.root = this.root == null && !rootNodes.isEmpty() ? (TreeNode<T>)rootNodes.get(0) : this.root;
        if (this.root == null) {
            throw new RuntimeException("\u6784\u5efa\u7ed3\u6784\u6811\u5931\u8d25,\u672a\u627e\u5230\u8ddf\u8282\u70b9");
        }
        this.nodes.addAll(rootNodes);
        this.nodes.addAll(childrenNodes);
    }
}

