/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.listener;

import com.horizon.core.common.service.SpringContextHolder;
import com.horizon.core.context.AbstractContext;
import com.horizon.core.init.HorizonInitAble;
import com.horizon.core.init.HorizonInitRegiester;
import com.horizon.language.LanguageUtil;
import com.horizon.license.StartApplication;
import com.horizon.profile.IStream;
import com.horizon.profile.api.ProfileContext;
import com.horizon.utils.HorizonPorps;
import com.horizon.utils.ServletContextUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HorizonWorkflowStartupListener
implements ServletContextListener {
    private Logger logger = LoggerFactory.getLogger(HorizonWorkflowStartupListener.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext context = servletContextEvent.getServletContext();
        this.logger.info("\u5de5\u4f5c\u6d41\u7cfb\u7edf\u542f\u52a8  \u5f00\u59cb");
        String projectPath = this.initApplicationPath(context);
        ServletContextUtil.setServletContext(context);
        this.initProps(context);
        Map map = SpringContextHolder.getApplicationContext().getBeansOfType(HorizonInitAble.class);
        for (Map.Entry item : map.entrySet()) {
            HorizonInitRegiester.regiest((HorizonInitAble)item.getValue());
        }
        HorizonInitRegiester.start();
        String product = HorizonPorps.getConfig("product");
        StartApplication.start((String)product, (String)projectPath);
        LanguageUtil.reloadLanguage();
        this.logger.info("\u5de5\u4f5c\u6d41\u7cfb\u7edf\u542f\u52a8  \u7ed3\u675f");
        HorizonInitRegiester.startAfterInit();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.logger.info("\u5de5\u4f5c\u6d41\u7cfb\u7edf   \u9500\u6bc1");
        HorizonInitRegiester.destroy();
    }

    private String initApplicationPath(ServletContext context) {
        String webPath = null;
        try {
            webPath = this.getAbsolutePathByContext(context);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (webPath == null) {
            try {
                webPath = this.getAbsolutePathByClass();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (webPath == null) {
            try {
                webPath = this.getAbsolutePathByResource(context);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.logger.info("  \u542f\u52a8\u4e2d...... \u8bbe\u7f6e\u7cfb\u7edf\u5de5\u7a0b\u8def\u5f84");
        AbstractContext abstractContext = new AbstractContext();
        abstractContext.setProjectPath(webPath);
        return webPath;
    }

    private String getAbsolutePathByContext(ServletContext context) throws Exception {
        String webPath = context.getRealPath("/");
        webPath = webPath.replaceAll("[\\\\\\/]WEB-INF[\\\\\\/]classes[\\\\\\/]?", "/");
        webPath = webPath.replaceAll("[\\\\\\/]+", "/");
        webPath = webPath.replaceAll("%20", " ");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" get Absolute Path By Context = " + webPath);
        }
        return this.slashReplaceAll(webPath);
    }

    private String getAbsolutePathByClass() throws Exception {
        String webPath = this.getClass().getResource("").getPath().replaceAll("^\\/", "");
        webPath = webPath.substring(0, webPath.indexOf("WEB-INF"));
        webPath = webPath.replaceAll("[\\\\\\/]WEB-INF[\\\\\\/]classes[\\\\\\/]?", "/");
        webPath = webPath.replaceAll("[\\\\\\/]+", "/");
        if (!(webPath = webPath.replaceAll("%20", " ")).matches("^[a-zA-Z]:.*?$")) {
            webPath = "/" + webPath;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" get Absolute Path By Class = " + webPath);
        }
        return this.slashReplaceAll(webPath);
    }

    private String getAbsolutePathByResource(ServletContext context) throws Exception {
        URL url = context.getResource("/");
        String path = new File(url.toURI()).getAbsolutePath();
        if (!path.endsWith("\\") && !path.endsWith("/")) {
            path = path + File.separator;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" get Absolute Path By Resource = " + path);
        }
        return path;
    }

    private String slashReplaceAll(String webPath) {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") != -1) {
            webPath = webPath.replaceAll("[\\\\\\/]+", "/");
        }
        int iLast = webPath.lastIndexOf("/");
        int iLength = webPath.length();
        if (iLength == iLast + 1) {
            webPath = webPath.substring(0, webPath.length() - 1);
        }
        return webPath;
    }

    private void initProps(ServletContext servletContext) {
        this.logger.info("  \u542f\u52a8\u4e2d...... \u52a0\u8f7d\u7cfb\u7edf\u5c5e\u6027\u6587\u4ef6");
        String fileAddress = servletContext.getInitParameter("profile");
        if (fileAddress == null) {
            fileAddress = "/WEB-INF/workflow-conf/properties";
        }
        final String filePath = fileAddress;
        ProfileContext.newInstance().setStreamUtil(new IStream(){

            @Override
            public String getRealPath(String path) {
                String temPath = path == null ? filePath : filePath + "/" + path;
                return ServletContextUtil.getRealPath(temPath);
            }

            @Override
            public OutputStream getOutPutStream(String path) throws IOException {
                return new FileOutputStream(this.getRealPath(path));
            }

            @Override
            public InputStream getInputStream(String path) throws IOException {
                return ServletContextUtil.getResourceAsStream(filePath + "/" + path);
            }
        }).build();
    }
}

