/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.context.holder;

import com.horizon.core.context.ContextAttributes;
import com.horizon.core.context.ContextThreadLocal;

public class ContextHolder {
    private static final ContextThreadLocal<ContextAttributes> contextHolder = new ContextThreadLocal("Horizon Context");

    public static void resetContext() {
        contextHolder.remove();
    }

    public static void setContext(ContextAttributes context) {
        if (context == null) {
            ContextHolder.resetContext();
        } else {
            context.setAttributes();
            contextHolder.set(context);
        }
    }

    public static ContextAttributes getContext() {
        return ContextHolder.currentContext();
    }

    private static ContextAttributes currentContext() throws IllegalStateException {
        ContextAttributes attributes = (ContextAttributes)contextHolder.get();
        return attributes;
    }
}

