/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.context;

import com.horizon.common.collect.Maps;
import com.horizon.language.Hi18n;
import com.horizon.profile.AppConfig;
import com.horizon.utils.HorizonPorps;
import com.horizon.utils.StringUtil;
import com.horizon.utils.json.JsonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

public class ExceptionHandler
extends SimpleMappingExceptionResolver
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandler.class);

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        LOGGER.error("", (Throwable)ex);
        if (!this.isAjax(request)) {
            request.setAttribute("msg", (Object)ex.getMessage());
            return super.doResolveException(request, response, handler, ex);
        }
        String servletPath = request.getServletPath();
        String errMessage = "";
        errMessage = servletPath.startsWith(HorizonPorps.getUrlPrefix() + "/rest") ? this.rederResponseResultJson(ex.getMessage()) : this.rederErrorJson(ex.getMessage());
        try {
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "no-cache, no-store, max-age=0");
            response.addDateHeader("Expires", 1L);
            response.setContentType("application/json;charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.write(errMessage);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        String errPage = AppConfig.get("horizon", "errorpage500");
        if (StringUtil.hasValue(errPage)) {
            Properties exceptionMappings = new Properties();
            exceptionMappings.setProperty("java.lang.Exception", errPage);
            exceptionMappings.setProperty("java.lang.Throwable", errPage);
            super.setExceptionMappings(exceptionMappings);
            super.addStatusCode(errPage, 500);
        }
    }

    private boolean isAjax(HttpServletRequest request) {
        return StringUtil.hasValue(request.getHeader("accept")) && request.getHeader("accept").contains("application/json") || StringUtil.hasValue(request.getHeader("X-Requested-With")) && request.getHeader("X-Requested-With").contains("XMLHttpRequest");
    }

    private String rederErrorJson(String message) {
        HashMap resMap = Maps.newHashMap();
        resMap.put("restype", "err");
        resMap.put("msg", message);
        return JsonUtil.toJsonSerializerNull(resMap);
    }

    private String rederResponseResultJson(String message) {
        HashMap map = Maps.newHashMap();
        map.put("success", false);
        map.put("code", 9999);
        map.put("message", Hi18n.getVal("rest-common", "systemError"));
        return JsonUtil.toJsonSerializerNull(map);
    }
}

