/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.context;

import com.horizon.core.HorizonCore;
import com.horizon.core.common.pagehelper.SqlUtil;
import com.horizon.core.context.Context;
import com.horizon.core.context.holder.ContextHolder;
import com.horizon.datasource.util.DataSourceContextHolder;
import java.util.Locale;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ContextListener
implements ServletRequestListener {
    private static final String REQUEST_ATTRIBUTES_ATTRIBUTE = RequestContextListener.class.getName() + ".REQUEST_ATTRIBUTES";
    private static final String HORIZON_CONTEXT_ATTRIBUTE = RequestContextListener.class.getName() + ".HORIZON_CONTEXT";

    public void requestInitialized(ServletRequestEvent requestEvent) {
        if (!(requestEvent.getServletRequest() instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HttpServletRequest: " + requestEvent.getServletRequest());
        }
        HttpServletRequest request = (HttpServletRequest)requestEvent.getServletRequest();
        ServletRequestAttributes attributes = new ServletRequestAttributes(request);
        Context baseContext = new Context(request);
        request.setAttribute(REQUEST_ATTRIBUTES_ATTRIBUTE, (Object)attributes);
        request.setAttribute(HORIZON_CONTEXT_ATTRIBUTE, (Object)baseContext);
        LocaleContextHolder.setLocale((Locale)request.getLocale());
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        ContextHolder.setContext(baseContext);
        DataSourceContextHolder.setDataSourceType(HorizonCore.TENANT_IDENTIFIER.value());
    }

    public void requestDestroyed(ServletRequestEvent requestEvent) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)requestEvent.getServletRequest().getAttribute(REQUEST_ATTRIBUTES_ATTRIBUTE);
        Context baseContext = (Context)requestEvent.getServletRequest().getAttribute(HORIZON_CONTEXT_ATTRIBUTE);
        ServletRequestAttributes threadAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (threadAttributes != null) {
            if (attributes == null) {
                attributes = threadAttributes;
            }
            LocaleContextHolder.resetLocaleContext();
            RequestContextHolder.resetRequestAttributes();
            ContextHolder.resetContext();
        }
        if (attributes != null) {
            attributes.requestCompleted();
            baseContext.requestCompleted();
        }
        SqlUtil.clearLocalPage();
    }
}

