/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.service.impl;

import com.horizon.core.common.entity.DataEntity;
import com.horizon.core.common.entity.Entity;
import com.horizon.core.common.repository.CoreRepository;
import com.horizon.core.common.service.ICoreService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CoreServiceImpl<M extends CoreRepository<T>, T extends DataEntity>
implements ICoreService<T> {
    protected M repository;

    @Autowired
    protected void setRepository(M repository) {
        this.repository = repository;
    }

    @Override
    public void save(T entity) {
        if (((Entity)entity).isNewRecord()) {
            ((DataEntity)entity).preInsert();
            this.repository.insert(entity);
        } else {
            ((DataEntity)entity).preUpdate();
            this.repository.update(entity);
        }
    }

    @Override
    public void insert(T entity) {
        this.repository.insert(entity);
    }

    @Override
    public void insertSelective(T entity) {
        this.repository.insertSelective(entity);
    }

    @Override
    public void deleteId(String id) {
        this.repository.deleteId(id);
    }

    @Override
    public void deleteSelective(T entity) {
        this.repository.deleteSelective(entity);
    }

    @Override
    public void deleteBatchIds(List<String> idList) {
        this.repository.deleteBatchIds(idList);
    }

    @Override
    public void update(T entity) {
        this.repository.update(entity);
    }

    @Override
    public void updateBatch(List<T> entityList) {
        this.repository.updateBatch(entityList);
    }

    @Override
    public T get(T entity) {
        return (T)((DataEntity)this.repository.get(entity));
    }

    @Override
    public T getId(String id) {
        return (T)((DataEntity)this.repository.getId(id));
    }

    @Override
    public int getCount(T entity) {
        return this.repository.getCount(entity);
    }

    @Override
    public List<T> findListIds(List<String> ids) {
        return this.repository.findListIds(ids);
    }

    @Override
    public List<T> findList(T entity) {
        return this.repository.findList(entity);
    }

    @Override
    public List<T> findList() {
        return this.repository.findList();
    }

    @Override
    public List<T> findParam(T entity) {
        return this.repository.findParam(entity);
    }
}

