/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.service;

import com.horizon.common.base.Joiner;
import com.horizon.common.collect.Maps;
import com.horizon.core.common.validate.HorizonMessageSource;
import com.horizon.utils.json.JsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.validation.MessageInterpolator;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Aspect
@Configuration
public class ValidateService {
    @Bean(name={"horizonValidator"})
    public LocalValidatorFactoryBean getLocalValidatorFactoryBean() {
        LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
        factoryBean.setProviderClass(HibernateValidator.class);
        final HorizonMessageSource messageSource = new HorizonMessageSource();
        ResourceBundleLocator locator = new ResourceBundleLocator(){

            public ResourceBundle getResourceBundle(Locale locale) {
                return new MessageSourceResourceBundle(messageSource, locale);
            }
        };
        factoryBean.setMessageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator(locator));
        return factoryBean;
    }

    @Pointcut(value="execution(String com.horizon..web..*Controller.*(..)) && args(..,org.springframework.validation.BindingResult+) ")
    private void executionValidate() {
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.ResponseBody)")
    private void executionValidate4Ajax() {
    }

    @Around(value="executionValidate()&&executionValidate4Ajax()")
    public Object executionWithPointCat(ProceedingJoinPoint thisJoinPoint) throws Throwable {
        Object[] args = thisJoinPoint.getArgs();
        if (args != null && args.length > 0) {
            for (Object object : args) {
                BindingResult result;
                if (!(object instanceof BindingResult) || !(result = (BindingResult)object).hasErrors()) continue;
                List errors = result.getAllErrors();
                Object[] errorMessage = new String[errors.size()];
                int len = errors.size();
                for (int i = 0; i < len; ++i) {
                    errorMessage[i] = ((ObjectError)errors.get(i)).getDefaultMessage();
                }
                return this.errorMessage(Joiner.on((String)";").join(errorMessage));
            }
        }
        return thisJoinPoint.proceed();
    }

    private Object errorMessage(String errorMessage) {
        HashMap resMap = Maps.newHashMap();
        resMap.put("restype", "err");
        resMap.put("msg", errorMessage);
        return JsonUtil.toJsonSerializerNull(resMap);
    }
}

