/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.service;

import com.horizon.core.common.event.SuperEvent;
import com.horizon.core.context.Context;
import com.horizon.core.context.ContextFactory;
import com.horizon.datasource.util.DataSourceContextHolder;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.stereotype.Service;

@Service(value="horizonSpringContextHolder")
@Lazy(value=false)
public class SpringContextHolder
implements ApplicationContextAware,
DisposableBean {
    private static ApplicationContext applicationContext = null;
    private static Logger logger = LoggerFactory.getLogger(SpringContextHolder.class);

    public static ApplicationContext getApplicationContext() {
        SpringContextHolder.assertContextInjected();
        return applicationContext;
    }

    public static void publishEvent(ApplicationEvent event) {
        SpringContextHolder.assertContextInjected();
        if (SuperEvent.class.isAssignableFrom(event.getClass())) {
            SuperEvent superEvent = (SuperEvent)event;
            superEvent.setDbIdentifer(DataSourceContextHolder.getDataSourceName());
            Context context = ContextFactory.INSTANCE.getContext();
            ConcurrentHashMap<String, Object> contextAttributes = new ConcurrentHashMap<String, Object>();
            contextAttributes.put("HORIZON_SESSION_USER_ID", context.getUserId());
            contextAttributes.put("HORIZON_SESSION_DEPT_ID", context.getDeptId());
            contextAttributes.put("HORIZON_SESSION_DEPT_NAME", context.getDeptName());
            contextAttributes.put("HORIZON_SESSION_TENANT_CODE", context.getTenantCode());
            contextAttributes.put("HORIZON_SESSION_TENANT_IDENTIFIER", context.getTenantIdentifier());
            contextAttributes.put("HORIZON_SESSION_TENANT_NAME", context.getTenantName());
            contextAttributes.put("HORIZON_SESSION_TENANT_CODE", context.getTenantCode());
            context = new Context();
            superEvent.setContextAttributes(contextAttributes);
        }
        applicationContext.publishEvent(event);
    }

    public static <T> T getBean(String name) {
        SpringContextHolder.assertContextInjected();
        if (!applicationContext.containsBean(name)) {
            return null;
        }
        return (T)applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        SpringContextHolder.assertContextInjected();
        try {
            return (T)applicationContext.getBean(requiredType);
        }
        catch (NoUniqueBeanDefinitionException e) {
            logger.error("\u5b58\u5728\u591a\u4e2aInstanceInitProperties", (Throwable)e);
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
    }

    public static void clearHolder() {
        logger.debug("\u6e05\u9664SpringContextHolder\u4e2d\u7684ApplicationContext:{}", (Object)applicationContext);
        applicationContext = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        SpringContextHolder.applicationContext = applicationContext;
    }

    public void destroy() throws Exception {
        SpringContextHolder.clearHolder();
    }

    public static <T> List<T> loadFactories(Class<T> factoryClass) {
        return SpringFactoriesLoader.loadFactories(factoryClass, null);
    }

    private static void assertContextInjected() {
        boolean isOk = applicationContext != null;
        String msg = "applicaitonContext\u5c5e\u6027\u672a\u6ce8\u5165, \u8bf7\u5728applicationContext.xml\u4e2d\u5b9a\u4e49SpringContextHolder.";
        Validate.validState((boolean)isOk, (String)msg, (Object[])new Object[0]);
    }
}

