/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper.sqlsource;

import com.horizon.apache.ibatis.builder.StaticSqlSource;
import com.horizon.apache.ibatis.mapping.BoundSql;
import com.horizon.apache.ibatis.mapping.ParameterMapping;
import com.horizon.apache.ibatis.mapping.SqlSource;
import com.horizon.apache.ibatis.reflection.MetaObject;
import com.horizon.apache.ibatis.reflection.SystemMetaObject;
import com.horizon.apache.ibatis.session.Configuration;
import com.horizon.core.common.pagehelper.PageHelper;
import com.horizon.core.common.pagehelper.parser.OrderByParser;
import com.horizon.core.common.pagehelper.parser.Parser;
import com.horizon.core.common.pagehelper.sqlsource.PageSqlSource;
import java.util.List;

public class PageStaticSqlSource
extends PageSqlSource {
    private String sql;
    private List<ParameterMapping> parameterMappings;
    private Configuration configuration;
    private SqlSource original;

    public PageStaticSqlSource(StaticSqlSource sqlSource) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)sqlSource);
        this.sql = (String)metaObject.getValue("sql");
        this.parameterMappings = (List)metaObject.getValue("parameterMappings");
        this.configuration = (Configuration)metaObject.getValue("configuration");
        this.original = sqlSource;
    }

    @Override
    protected BoundSql getDefaultBoundSql(Object parameterObject) {
        String tempSql = this.sql;
        String orderBy = PageHelper.getOrderBy();
        if (orderBy != null) {
            tempSql = OrderByParser.converToOrderBySql(this.sql, orderBy);
        }
        return new BoundSql(this.configuration, tempSql, this.parameterMappings, parameterObject);
    }

    @Override
    protected BoundSql getCountBoundSql(Object parameterObject) {
        return new BoundSql(this.configuration, ((Parser)localParser.get()).getCountSql(this.sql), this.parameterMappings, parameterObject);
    }

    @Override
    protected BoundSql getPageBoundSql(Object parameterObject) {
        String tempSql = this.sql;
        String orderBy = PageHelper.getOrderBy();
        if (orderBy != null) {
            tempSql = OrderByParser.converToOrderBySql(this.sql, orderBy);
        }
        tempSql = ((Parser)localParser.get()).getPageSql(tempSql);
        return new BoundSql(this.configuration, tempSql, ((Parser)localParser.get()).getPageParameterMapping(this.configuration, this.original.getBoundSql(parameterObject)), parameterObject);
    }
}

