/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper.sqlsource;

import com.horizon.apache.ibatis.builder.BuilderException;
import com.horizon.apache.ibatis.builder.SqlSourceBuilder;
import com.horizon.apache.ibatis.builder.StaticSqlSource;
import com.horizon.apache.ibatis.builder.annotation.ProviderSqlSource;
import com.horizon.apache.ibatis.mapping.BoundSql;
import com.horizon.apache.ibatis.mapping.SqlSource;
import com.horizon.apache.ibatis.reflection.MetaObject;
import com.horizon.apache.ibatis.reflection.SystemMetaObject;
import com.horizon.apache.ibatis.session.Configuration;
import com.horizon.core.common.pagehelper.Constant;
import com.horizon.core.common.pagehelper.parser.Parser;
import com.horizon.core.common.pagehelper.sqlsource.OrderByStaticSqlSource;
import com.horizon.core.common.pagehelper.sqlsource.PageSqlSource;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class PageProviderSqlSource
extends PageSqlSource
implements Constant {
    private SqlSourceBuilder sqlSourceParser;
    private Class<?> providerType;
    private Method providerMethod;
    private Boolean providerTakesParameterObject;
    private Configuration configuration;

    public PageProviderSqlSource(ProviderSqlSource provider) {
        MetaObject metaObject = SystemMetaObject.forObject((Object)provider);
        this.sqlSourceParser = (SqlSourceBuilder)metaObject.getValue("sqlSourceParser");
        this.providerType = (Class)metaObject.getValue("providerType");
        this.providerMethod = (Method)metaObject.getValue("providerMethod");
        this.providerTakesParameterObject = (Boolean)metaObject.getValue("providerTakesParameterObject");
        this.configuration = (Configuration)metaObject.getValue("sqlSourceParser.configuration");
    }

    private SqlSource createSqlSource(Object parameterObject) {
        try {
            String sql = this.providerTakesParameterObject != false ? (String)this.providerMethod.invoke(this.providerType.newInstance(), parameterObject) : (String)this.providerMethod.invoke(this.providerType.newInstance(), new Object[0]);
            Class parameterType = parameterObject == null ? Object.class : parameterObject.getClass();
            StaticSqlSource sqlSource = (StaticSqlSource)this.sqlSourceParser.parse(sql, parameterType, new HashMap());
            return new OrderByStaticSqlSource(sqlSource);
        }
        catch (Exception e) {
            throw new BuilderException("Error invoking SqlProvider method (" + this.providerType.getName() + "." + this.providerMethod.getName() + ").  Cause: " + e, (Throwable)e);
        }
    }

    @Override
    protected BoundSql getDefaultBoundSql(Object parameterObject) {
        SqlSource sqlSource = this.createSqlSource(parameterObject);
        return sqlSource.getBoundSql(parameterObject);
    }

    @Override
    protected BoundSql getCountBoundSql(Object parameterObject) {
        SqlSource sqlSource = this.createSqlSource(parameterObject);
        BoundSql boundSql = sqlSource.getBoundSql(parameterObject);
        return new BoundSql(this.configuration, ((Parser)localParser.get()).getCountSql(boundSql.getSql()), boundSql.getParameterMappings(), parameterObject);
    }

    @Override
    protected BoundSql getPageBoundSql(Object parameterObject) {
        BoundSql boundSql;
        if (parameterObject instanceof Map && ((Map)parameterObject).containsKey("_provider_object")) {
            SqlSource sqlSource = this.createSqlSource(((Map)parameterObject).get("_provider_object"));
            boundSql = sqlSource.getBoundSql(((Map)parameterObject).get("_provider_object"));
        } else {
            SqlSource sqlSource = this.createSqlSource(parameterObject);
            boundSql = sqlSource.getBoundSql(parameterObject);
        }
        return new BoundSql(this.configuration, ((Parser)localParser.get()).getPageSql(boundSql.getSql()), ((Parser)localParser.get()).getPageParameterMapping(this.configuration, boundSql), parameterObject);
    }
}

