/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper.regex;

import com.horizon.core.common.pagehelper.regex.ASCII;
import com.horizon.core.common.pagehelper.regex.Capture;
import com.horizon.core.common.pagehelper.regex.MatchResult;
import com.horizon.core.common.pagehelper.regex.Pattern;
import java.util.Stack;
import java.util.Vector;

public final class Matcher
implements MatchResult {
    Pattern parentPattern;
    Vector<Stack<Capture>> captures;
    int from;
    int to;
    int lookbehindTo;
    CharSequence text;
    static final int ENDANCHOR = 1;
    static final int NOANCHOR = 0;
    int acceptMode = 0;
    int first = -1;
    int last = 0;
    int oldLast = -1;
    int lastAppendPosition = 0;
    Vector<Stack<Integer>> localVector;
    Pattern.Node[] nextNodes;
    boolean hitEnd;
    boolean requireEnd;
    boolean transparentBounds = false;
    boolean anchoringBounds = true;

    Matcher() {
    }

    Matcher(Pattern parent, CharSequence text) {
        this.parentPattern = parent;
        this.text = text;
        int parentGroupCount = Math.max(parent.capturingGroupCount, 10);
        this.captures = new Vector(parentGroupCount);
        this.captures.setSize(parentGroupCount);
        this.localVector = new Vector(parent.localCount);
        this.localVector.setSize(parent.localCount);
        this.nextNodes = new Pattern.Node[parent.localCount];
        this.reset();
    }

    public Pattern pattern() {
        return this.parentPattern;
    }

    public MatchResult toMatchResult() {
        Matcher result = new Matcher(this.parentPattern, this.text.toString());
        result.first = this.first;
        result.last = this.last;
        result.captures = this.cloneCaptures();
        return result;
    }

    public Matcher usePattern(Pattern newPattern) {
        if (newPattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.parentPattern = newPattern;
        int parentGroupCount = Math.max(newPattern.capturingGroupCount, 10);
        this.localVector = new Vector(newPattern.localCount);
        this.localVector.setSize(newPattern.localCount);
        for (int i = 0; i < this.localVector.size(); ++i) {
            this.localVector.set(i, new Stack());
        }
        this.nextNodes = new Pattern.Node[newPattern.localCount];
        return this;
    }

    public Matcher reset() {
        int i;
        this.first = -1;
        this.last = 0;
        this.oldLast = -1;
        for (i = 0; i < this.captures.size(); ++i) {
            this.captures.set(i, new Stack());
        }
        for (i = 0; i < this.localVector.size(); ++i) {
            this.localVector.set(i, new Stack());
            this.nextNodes[i] = null;
        }
        this.lastAppendPosition = 0;
        this.from = 0;
        this.to = this.getTextLength();
        return this;
    }

    public Matcher reset(CharSequence input) {
        this.text = input;
        return this.reset();
    }

    @Override
    public int start() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.first;
    }

    @Override
    public int start(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        if (this.captures.get(group).isEmpty()) {
            return -1;
        }
        return this.captures.get(group).peek().getStart();
    }

    @Override
    public int start(String name) {
        int group = this.getMatchedGroupIndex(name);
        if (this.captures.get(group).isEmpty()) {
            return -1;
        }
        return this.captures.get(group).peek().getStart();
    }

    @Override
    public int end() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.last;
    }

    @Override
    public int end(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        if (this.captures.get(group).isEmpty()) {
            return -1;
        }
        return this.captures.get(group).peek().getEnd();
    }

    @Override
    public int end(String name) {
        int group = this.getMatchedGroupIndex(name);
        if (this.captures.get(group).isEmpty()) {
            return -1;
        }
        return this.captures.get(group).peek().getEnd();
    }

    @Override
    public String group() {
        return this.group(0);
    }

    @Override
    public String group(int group) {
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        if (this.captures.get(group).isEmpty()) {
            return null;
        }
        Capture last = this.captures.get(group).peek();
        return last.getValue();
    }

    @Override
    public String group(String name) {
        int group = this.getMatchedGroupIndex(name);
        if (this.captures.get(group).isEmpty()) {
            return null;
        }
        Capture last = this.captures.get(group).peek();
        return last.getValue();
    }

    @Override
    public Stack<Capture> captures(int group) {
        if (group < 0 || group > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + group);
        }
        return this.captures.get(group);
    }

    @Override
    public Stack<Capture> captures(String name) {
        int group = this.getMatchedGroupIndex(name);
        return this.captures(group);
    }

    @Override
    public int groupCount() {
        return this.parentPattern.capturingGroupCount - 1;
    }

    public boolean matches() {
        return this.match(this.from, 1);
    }

    public boolean find() {
        int nextSearchIndex = this.last;
        if (nextSearchIndex == this.first) {
            ++nextSearchIndex;
        }
        if (nextSearchIndex < this.from) {
            nextSearchIndex = this.from;
        }
        if (nextSearchIndex > this.to) {
            for (int i = 0; i < this.captures.size(); ++i) {
                this.captures.set(i, new Stack());
            }
            return false;
        }
        return this.search(nextSearchIndex);
    }

    public boolean find(int start) {
        int limit = this.getTextLength();
        if (start < 0 || start > limit) {
            throw new IndexOutOfBoundsException("Illegal start index");
        }
        this.reset();
        return this.search(start);
    }

    public boolean lookingAt() {
        return this.match(this.from, 0);
    }

    public static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '$') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Matcher appendReplacement(StringBuffer sb, String replacement) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        int cursor = 0;
        StringBuilder result = new StringBuilder();
        while (cursor < replacement.length()) {
            char nextChar = replacement.charAt(cursor);
            if (nextChar == '\\') {
                if (++cursor == replacement.length()) {
                    throw new IllegalArgumentException("character to be escaped is missing");
                }
                nextChar = replacement.charAt(cursor);
                result.append(nextChar);
                ++cursor;
                continue;
            }
            if (nextChar == '$') {
                if (++cursor == replacement.length()) {
                    throw new IllegalArgumentException("Illegal group reference: group index is missing");
                }
                nextChar = replacement.charAt(cursor);
                int refNum = -1;
                if (nextChar == '{') {
                    ++cursor;
                    StringBuilder gsb = new StringBuilder();
                    while (cursor < replacement.length() && (ASCII.isLower(nextChar = replacement.charAt(cursor)) || ASCII.isUpper(nextChar) || ASCII.isDigit(nextChar))) {
                        gsb.append(nextChar);
                        ++cursor;
                    }
                    if (gsb.length() == 0) {
                        throw new IllegalArgumentException("named capturing group has 0 length name");
                    }
                    if (nextChar != '}') {
                        throw new IllegalArgumentException("named capturing group is missing trailing '}'");
                    }
                    String gname = gsb.toString();
                    if (ASCII.isDigit(gname.charAt(0))) {
                        throw new IllegalArgumentException("capturing group name {" + gname + "} starts with digit character");
                    }
                    if (!this.parentPattern.namedGroups().containsKey(gname)) {
                        throw new IllegalArgumentException("No group with name {" + gname + "}");
                    }
                    refNum = this.parentPattern.namedGroups().get(gname);
                    ++cursor;
                } else {
                    int nextDigit;
                    refNum = nextChar - 48;
                    if (refNum < 0 || refNum > 9) {
                        throw new IllegalArgumentException("Illegal group reference");
                    }
                    ++cursor;
                    boolean done = false;
                    while (!done && cursor < replacement.length() && (nextDigit = replacement.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                        int newRefNum = refNum * 10 + nextDigit;
                        if (this.groupCount() < newRefNum) {
                            done = true;
                            continue;
                        }
                        refNum = newRefNum;
                        ++cursor;
                    }
                }
                if (this.start(refNum) == -1 || this.end(refNum) == -1) continue;
                result.append(this.text, this.start(refNum), this.end(refNum));
                continue;
            }
            result.append(nextChar);
            ++cursor;
        }
        sb.append(this.text, this.lastAppendPosition, this.first);
        sb.append((CharSequence)result);
        this.lastAppendPosition = this.last;
        return this;
    }

    public StringBuffer appendTail(StringBuffer sb) {
        sb.append(this.text, this.lastAppendPosition, this.getTextLength());
        return sb;
    }

    public String replaceAll(String replacement) {
        this.reset();
        boolean result = this.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                this.appendReplacement(sb, replacement);
            } while (result = this.find());
            this.appendTail(sb);
            return sb.toString();
        }
        return this.text.toString();
    }

    public String replaceFirst(String replacement) {
        if (replacement == null) {
            throw new NullPointerException("replacement");
        }
        this.reset();
        if (!this.find()) {
            return this.text.toString();
        }
        StringBuffer sb = new StringBuffer();
        this.appendReplacement(sb, replacement);
        this.appendTail(sb);
        return sb.toString();
    }

    public Matcher region(int start, int end) {
        if (start < 0 || start > this.getTextLength()) {
            throw new IndexOutOfBoundsException("start");
        }
        if (end < 0 || end > this.getTextLength()) {
            throw new IndexOutOfBoundsException("end");
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start > end");
        }
        this.reset();
        this.from = start;
        this.to = end;
        return this;
    }

    public int regionStart() {
        return this.from;
    }

    public int regionEnd() {
        return this.to;
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    public Matcher useTransparentBounds(boolean b) {
        this.transparentBounds = b;
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds;
    }

    public Matcher useAnchoringBounds(boolean b) {
        this.anchoringBounds = b;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("java.util.regex.Matcher");
        sb.append("[pattern=" + this.pattern());
        sb.append(" region=");
        sb.append(this.regionStart() + "," + this.regionEnd());
        sb.append(" lastmatch=");
        if (this.first >= 0 && this.group() != null) {
            sb.append(this.group());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean hitEnd() {
        return this.hitEnd;
    }

    public boolean requireEnd() {
        return this.requireEnd;
    }

    boolean search(int from) {
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = from = from < 0 ? 0 : from;
        this.oldLast = this.oldLast < 0 ? from : this.oldLast;
        for (int i = 0; i < this.captures.size(); ++i) {
            this.captures.set(i, new Stack());
        }
        this.acceptMode = 0;
        boolean result = this.parentPattern.root.match(this, from, this.text);
        if (!result) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return result;
    }

    boolean match(int from, int anchor) {
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = from = from < 0 ? 0 : from;
        this.oldLast = this.oldLast < 0 ? from : this.oldLast;
        for (int i = 0; i < this.captures.size(); ++i) {
            this.captures.set(i, new Stack());
        }
        this.acceptMode = anchor;
        boolean result = this.parentPattern.matchRoot.match(this, from, this.text);
        if (!result) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return result;
    }

    int getTextLength() {
        return this.text.length();
    }

    CharSequence getSubSequence(int beginIndex, int endIndex) {
        return this.text.subSequence(beginIndex, endIndex);
    }

    char charAt(int i) {
        return this.text.charAt(i);
    }

    int getMatchedGroupIndex(String name) {
        if (name == null) {
            throw new NullPointerException("Group name");
        }
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (!this.parentPattern.namedGroups().containsKey(name)) {
            throw new IllegalArgumentException("No group with name <" + name + ">");
        }
        return this.parentPattern.namedGroups().get(name);
    }

    void setGroup0(CharSequence seq, int start, int end) {
        Capture capture = new Capture(seq, start, end);
        if (this.captures.get(0).isEmpty()) {
            this.captures.get(0).push(capture);
        } else {
            this.captures.get(0).set(0, capture);
        }
    }

    private Stack<Capture> cloneCaptureStack(Stack<Capture> toClone) {
        Stack<Capture> clone = new Stack<Capture>();
        clone.setSize(toClone.size());
        for (int i = 0; i < toClone.size(); ++i) {
            clone.set(i, toClone.get(i) == null ? null : ((Capture)toClone.get(i)).clone());
        }
        return clone;
    }

    Vector<Stack<Capture>> cloneCaptures() {
        Vector<Stack<Capture>> clone = new Vector<Stack<Capture>>(this.captures.size());
        clone.setSize(this.captures.size());
        for (int i = 0; i < this.captures.size(); ++i) {
            clone.set(i, this.cloneCaptureStack(this.captures.get(i)));
        }
        return clone;
    }
}

