/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper.parser.impl;

import com.horizon.apache.ibatis.mapping.BoundSql;
import com.horizon.apache.ibatis.mapping.MappedStatement;
import com.horizon.apache.ibatis.mapping.ParameterMapping;
import com.horizon.apache.ibatis.session.Configuration;
import com.horizon.core.common.pagehelper.Page;
import com.horizon.core.common.pagehelper.SqlUtil;
import com.horizon.core.common.pagehelper.parser.SqlServer;
import com.horizon.core.common.pagehelper.parser.impl.AbstractParser;
import com.horizon.utils.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlServerParser
extends AbstractParser {
    private static final SqlServer pageSql = new SqlServer();
    private static String[] SQLSERVER = new String[]{" + ", "GETDATE()", "CONVERT(CHAR(20),HQL_TMP_PARA,20)", "CONVERT(CHAR(8),HQL_TMP_PARA,108)", "SUBSTRING", "DATEADD(mm,HQL_TMP_PARA_NO,HQL_TMP_PARA_DATE)", "CHARINDEX(HQL_TMP_PARA_SUBSTR,HQL_TMP_PARA_STR,1)", "LEN", "REPLACE(HQL_TMP_SOURCE_STR,HQL_TMP_SEARCH_STR,HQL_TMP_REPLACEMENT_STR)", "CONVERT(CHAR(7),HQL_TMP_PARA,20)", "CONVERT(CHAR(4),HQL_TMP_PARA,20)", "CONVERT(CHAR(16),HQL_TMP_PARA,20)", "CONVERT(CHAR(19),HQL_TMP_PARA,20)", "CAST(HQL_TMP_PARA AS INTEGER)", "HQL_TMP_PARA", "CAST(HQL_TMP_PARA AS datetime)"};

    @Override
    protected String[] getKey() {
        return SQLSERVER;
    }

    @Override
    public String dealHqlReplace(String sql) {
        Pattern p = Pattern.compile(HQLEXP[8]);
        Pattern argp = Pattern.compile("\\s*\\(([^)]+\\s*)\\)");
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        String formula = "";
        StringBuffer sb = new StringBuffer();
        while (result) {
            String[] argments;
            Matcher argm = argp.matcher(m.group(0).toString());
            if (argm.find() && !(argments = SqlServerParser.splitargs(argm.group(0).toString()))[1].equals("")) {
                formula = SQLSERVER[8].replaceAll("HQL_TMP_SOURCE_STR", argments[1]);
                formula = formula.replaceAll("HQL_TMP_SEARCH_STR", argments[2]);
                formula = formula.replaceAll("HQL_TMP_REPLACEMENT_STR", argments[3]);
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public boolean isSupportedMappedStatementCache() {
        return false;
    }

    @Override
    public List<ParameterMapping> getPageParameterMapping(Configuration configuration, BoundSql boundSql) {
        return boundSql.getParameterMappings();
    }

    @Override
    public String getPageSql(String sql) {
        if (super.isSubPage(sql)) {
            return this.dealPageHql(sql);
        }
        Page page = SqlUtil.getLocalPage();
        return pageSql.convertToPageSql(sql, page.getStartRow(), page.getPageSize());
    }

    @Override
    public Map<String, Object> setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page<?> page) {
        return super.setPageParameter(ms, parameterObject, boundSql, page);
    }

    private String dealPageHql(String sql) {
        com.horizon.core.common.pagehelper.regex.Matcher matcher = com.horizon.core.common.pagehelper.regex.Pattern.compile("(\\(([^()]+|(?1))*+\\))\\s*HQL_PAGE").matcher(sql);
        boolean result = matcher.find();
        StringBuffer sb = new StringBuffer();
        if (!result) {
            return sql;
        }
        String content = matcher.group(1);
        if (StringUtil.hasValue(content) && content.startsWith("(") && content.endsWith(")")) {
            content = content.substring(1, content.length() - 1);
            Page page = SqlUtil.getLocalPage();
            content = pageSql.convertToPageSql(content, page.getStartRow(), page.getPageSize());
            content = "(" + content + ") HQL_PAGE";
            matcher.appendReplacement(sb, content);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

