/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper.parser.impl;

import com.horizon.apache.ibatis.mapping.BoundSql;
import com.horizon.apache.ibatis.mapping.MappedStatement;
import com.horizon.apache.ibatis.mapping.ParameterMapping;
import com.horizon.apache.ibatis.session.Configuration;
import com.horizon.core.common.pagehelper.Page;
import com.horizon.core.common.pagehelper.parser.impl.AbstractParser;
import com.horizon.core.common.pagehelper.regex.Matcher;
import com.horizon.core.common.pagehelper.regex.Pattern;
import com.horizon.utils.StringUtil;
import java.util.List;
import java.util.Map;

public class OscarParser
extends AbstractParser {
    private static final String[] OSCAR = new String[]{" || ", "SYSDATE", "TO_DATE(HQL_TMP_PARA,'yyyy-mm-dd hh24:mi:ss')", "TO_CHAR(HQL_TMP_PARA,'hh24:mi:ss')", "SUBSTR", "ADD_MONTHS(HQL_TMP_PARA_DATE,HQL_TMP_PARA_NO)", "INSTR(HQL_TMP_PARA_STR,HQL_TMP_PARA_SUBSTR)", "LENGTH", "REPLACE(HQL_TMP_SOURCE_STR,HQL_TMP_SEARCH_STR,HQL_TMP_REPLACEMENT_STR)", "TO_CHAR(HQL_TMP_PARA,'yyyy-mm')", "TO_CHAR(TO_DATE(HQL_TMP_PARA,'yyyy-mm-dd hh24:mi:ss'),'yyyy')", "TO_CHAR(HQL_TMP_PARA,'yyyy-mm-dd hh24:mi')", "TO_CHAR(HQL_TMP_PARA,'yyyy-mm-dd hh24:mi:ss')", "CAST(HQL_TMP_PARA AS INTEGER)", "HQL_TMP_PARA", "TO_TIMESTAMP(HQL_TMP_PARA,'yyyy-mm-dd hh24:mi:ss')"};

    @Override
    protected String[] getKey() {
        return OSCAR;
    }

    @Override
    public String getPageSql(String sql) {
        if (super.isSubPage(sql)) {
            return this.dealPageHql(sql);
        }
        StringBuilder sqlBuilder = new StringBuilder(sql.length() + 120);
        sqlBuilder.append("select * from ( select tmp_page.*, rownum row_id from ( ");
        sqlBuilder.append(sql);
        sqlBuilder.append(" ) tmp_page where rownum <= ? ) where row_id > ?");
        return sqlBuilder.toString();
    }

    @Override
    public List<ParameterMapping> getPageParameterMapping(Configuration configuration, BoundSql boundSql) {
        return super.pageParameterMapping(configuration, boundSql);
    }

    @Override
    public Map<String, Object> setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page<?> page) {
        Map<String, Object> paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
        paramMap.put("First_PageHelper", page.getEndRow());
        paramMap.put("Second_PageHelper", page.getStartRow());
        return paramMap;
    }

    private String dealPageHql(String sql) {
        Matcher matcher = Pattern.compile("(\\(([^()]+|(?1))*+\\))\\s*HQL_PAGE").matcher(sql);
        boolean result = matcher.find();
        StringBuffer sb = new StringBuffer();
        if (!result) {
            return sql;
        }
        String content = matcher.group(1);
        if (StringUtil.hasValue(content) && content.startsWith("(") && content.endsWith(")")) {
            content = content.substring(1, content.length() - 1);
            content = "(select * from ( select tmp_page.*, rownum row_id from (" + content + ") tmp_page where rownum <= ?) where row_id >?) HQL_PAGE";
            matcher.appendReplacement(sb, content);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

