/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper.parser.impl;

import com.horizon.apache.ibatis.mapping.BoundSql;
import com.horizon.apache.ibatis.mapping.MappedStatement;
import com.horizon.apache.ibatis.mapping.ParameterMapping;
import com.horizon.apache.ibatis.session.Configuration;
import com.horizon.core.common.pagehelper.Page;
import com.horizon.core.common.pagehelper.parser.impl.AbstractParser;
import com.horizon.core.common.pagehelper.regex.Matcher;
import com.horizon.core.common.pagehelper.regex.Pattern;
import com.horizon.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InformixParser
extends AbstractParser {
    @Override
    public String getPageSql(String sql) {
        if (super.isSubPage(sql)) {
            return this.dealPageHql(sql);
        }
        StringBuilder sqlBuilder = new StringBuilder(sql.length() + 40);
        sqlBuilder.append("select skip ? first ? * from ( ");
        sqlBuilder.append(sql);
        sqlBuilder.append(" ) temp_t");
        return sqlBuilder.toString();
    }

    @Override
    public List<ParameterMapping> getPageParameterMapping(Configuration configuration, BoundSql boundSql) {
        String sql = boundSql.getSql();
        Matcher matcher = Pattern.compile("(\\(([^()]+|(?1))*+\\))\\s*HQL_PAGE").matcher(sql);
        boolean result = matcher.find();
        if (!result) {
            ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>();
            newParameterMappings.add(new ParameterMapping.Builder(configuration, "First_PageHelper", Integer.class).build());
            newParameterMappings.add(new ParameterMapping.Builder(configuration, "Second_PageHelper", Integer.class).build());
            if (boundSql.getParameterMappings() != null) {
                newParameterMappings.addAll(boundSql.getParameterMappings());
            }
            return newParameterMappings;
        }
        ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>();
        if (boundSql != null && boundSql.getParameterMappings() != null) {
            newParameterMappings.addAll(boundSql.getParameterMappings());
        }
        String content = matcher.group(0);
        int lastIndex = super.countParam(content, "?");
        newParameterMappings.add(lastIndex, new ParameterMapping.Builder(configuration, "First_PageHelper", Integer.class).build());
        newParameterMappings.add(lastIndex + 1, new ParameterMapping.Builder(configuration, "Second_PageHelper", Integer.class).build());
        return newParameterMappings;
    }

    @Override
    public Map<String, Object> setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page<?> page) {
        Map<String, Object> paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
        paramMap.put("First_PageHelper", page.getStartRow());
        paramMap.put("Second_PageHelper", page.getPageSize());
        return paramMap;
    }

    private String dealPageHql(String sql) {
        Matcher matcher = Pattern.compile("(\\(([^()]+|(?1))*+\\))\\s*HQL_PAGE").matcher(sql);
        boolean result = matcher.find();
        StringBuffer sb = new StringBuffer();
        if (!result) {
            return sql;
        }
        String content = matcher.group(1);
        if (StringUtil.hasValue(content) && content.startsWith("(") && content.endsWith(")")) {
            content = content.substring(1, content.length() - 1);
            content = "(select skip ? first ? * from (" + content + ") temp_t) HQL_PAGE";
            matcher.appendReplacement(sb, content);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

