/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper.parser.impl;

import com.horizon.apache.ibatis.mapping.BoundSql;
import com.horizon.apache.ibatis.mapping.MappedStatement;
import com.horizon.apache.ibatis.mapping.ParameterMapping;
import com.horizon.apache.ibatis.session.Configuration;
import com.horizon.core.common.pagehelper.Page;
import com.horizon.core.common.pagehelper.parser.impl.AbstractParser;
import com.horizon.core.common.pagehelper.regex.Matcher;
import com.horizon.core.common.pagehelper.regex.Pattern;
import com.horizon.utils.StringUtil;
import java.util.List;
import java.util.Map;

public class HsqldbParser
extends AbstractParser {
    @Override
    public String getPageSql(String sql) {
        if (super.isSubPage(sql)) {
            return this.dealPageHql(sql);
        }
        StringBuilder sqlBuilder = new StringBuilder(sql.length() + 20);
        sqlBuilder.append(sql);
        sqlBuilder.append(" limit ? offset ?");
        return sqlBuilder.toString();
    }

    @Override
    public List<ParameterMapping> getPageParameterMapping(Configuration configuration, BoundSql boundSql) {
        return super.pageParameterMapping(configuration, boundSql);
    }

    @Override
    public Map<String, Object> setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page<?> page) {
        Map<String, Object> paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
        paramMap.put("First_PageHelper", page.getPageSize());
        paramMap.put("Second_PageHelper", page.getStartRow());
        return paramMap;
    }

    private String dealPageHql(String sql) {
        Matcher matcher = Pattern.compile("(\\(([^()]+|(?1))*+\\))\\s*HQL_PAGE").matcher(sql);
        boolean result = matcher.find();
        StringBuffer sb = new StringBuffer();
        if (!result) {
            return sql;
        }
        String content = matcher.group(1);
        if (StringUtil.hasValue(content) && content.startsWith("(") && content.endsWith(")")) {
            content = content.substring(1, content.length() - 1);
            content = "(" + content + " limit ? offset ?) HQL_PAGE";
            matcher.appendReplacement(sb, content);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

