/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper.parser.impl;

import com.horizon.apache.ibatis.mapping.BoundSql;
import com.horizon.apache.ibatis.mapping.MappedStatement;
import com.horizon.apache.ibatis.mapping.ParameterMapping;
import com.horizon.apache.ibatis.session.Configuration;
import com.horizon.core.common.pagehelper.Page;
import com.horizon.core.common.pagehelper.parser.impl.AbstractParser;
import com.horizon.core.common.pagehelper.regex.Matcher;
import com.horizon.core.common.pagehelper.regex.Pattern;
import com.horizon.utils.StringUtil;
import java.util.List;
import java.util.Map;

public class Db2Parser
extends AbstractParser {
    private static final String[] DB2 = new String[]{" || ", "current timestamp", "LEFT(TO_CHAR(HQL_TMP_PARA, 'YYYY-MM-DD HH24:MI:SS'),10)", "RIGHT(TO_CHAR(HQL_TMP_PARA,'HH24:MI:SS'),8)", "substr", "HQL_TMP_PARA_DATE + HQL_TMP_PARA_NO", "posstr(HQL_TMP_PARA_STR,HQL_TMP_PARA_SUBSTR)", "length", "replace(HQL_TMP_SOURCE_STR,HQL_TMP_SEARCH_STR,HQL_TMP_REPLACEMENT_STR)", "LEFT(TO_CHAR(HQL_TMP_PARA, 'YYYY-MM-DD HH24:MI:SS'),7)", "LEFT(TO_CHAR(HQL_TMP_PARA, 'YYYY-MM-DD HH24:MI:SS'),4)", "LEFT(TO_CHAR(HQL_TMP_PARA, 'YYYY-MM-DD HH24:MI:SS'),18)", "LEFT(TO_CHAR(HQL_TMP_PARA, 'YYYY-MM-DD HH24:MI:SS'),21)", "CAST(HQL_TMP_PARA AS BIGINT)", "TO_CHAR(HQL_TMP_PARA)", "TIMESTAMP(HQL_TMP_PARA)"};

    @Override
    protected String[] getKey() {
        return DB2;
    }

    @Override
    public String getPageSql(String sql) {
        if (super.isSubPage(sql)) {
            return this.dealPageHql(sql);
        }
        StringBuilder sqlBuilder = new StringBuilder(sql.length() + 120);
        sqlBuilder.append("select * from (select tmp_page.*,rownumber() over() as row_id from ( ");
        sqlBuilder.append(sql);
        sqlBuilder.append(" ) as tmp_page) where row_id between ? and ?");
        return sqlBuilder.toString();
    }

    @Override
    public List<ParameterMapping> getPageParameterMapping(Configuration configuration, BoundSql boundSql) {
        return super.pageParameterMapping(configuration, boundSql);
    }

    @Override
    public Map<String, Object> setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page<?> page) {
        Map<String, Object> paramMap = super.setPageParameter(ms, parameterObject, boundSql, page);
        paramMap.put("First_PageHelper", page.getStartRow() + 1);
        paramMap.put("Second_PageHelper", page.getEndRow());
        return paramMap;
    }

    private String dealPageHql(String sql) {
        Matcher matcher = Pattern.compile("(\\(([^()]+|(?1))*+\\))\\s*HQL_PAGE").matcher(sql);
        boolean result = matcher.find();
        StringBuffer sb = new StringBuffer();
        if (!result) {
            return sql;
        }
        String content = matcher.group(1);
        if (StringUtil.hasValue(content) && content.startsWith("(") && content.endsWith(")")) {
            content = content.substring(1, content.length() - 1);
            content = "(select * from (select tmp_page.*,rownumber() over() as row_id from (" + content + ") as tmp_page) where row_id between ? and ?) HQL_PAGE";
            matcher.appendReplacement(sb, content);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

