/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper.parser.impl;

import com.horizon.apache.ibatis.mapping.BoundSql;
import com.horizon.apache.ibatis.mapping.MappedStatement;
import com.horizon.apache.ibatis.mapping.ParameterMapping;
import com.horizon.apache.ibatis.reflection.MetaObject;
import com.horizon.apache.ibatis.reflection.SystemMetaObject;
import com.horizon.apache.ibatis.session.Configuration;
import com.horizon.common.collect.Lists;
import com.horizon.core.common.pagehelper.Constant;
import com.horizon.core.common.pagehelper.Dialect;
import com.horizon.core.common.pagehelper.Page;
import com.horizon.core.common.pagehelper.parser.Parser;
import com.horizon.core.common.pagehelper.parser.SqlParser;
import com.horizon.core.common.pagehelper.parser.impl.DMParser;
import com.horizon.core.common.pagehelper.parser.impl.Db2Parser;
import com.horizon.core.common.pagehelper.parser.impl.GBase8sParser;
import com.horizon.core.common.pagehelper.parser.impl.GBaseParser;
import com.horizon.core.common.pagehelper.parser.impl.GaussParser;
import com.horizon.core.common.pagehelper.parser.impl.H2Parser;
import com.horizon.core.common.pagehelper.parser.impl.HighgoParser;
import com.horizon.core.common.pagehelper.parser.impl.HsqldbParser;
import com.horizon.core.common.pagehelper.parser.impl.InformixParser;
import com.horizon.core.common.pagehelper.parser.impl.KingBaseParser;
import com.horizon.core.common.pagehelper.parser.impl.MysqlParser;
import com.horizon.core.common.pagehelper.parser.impl.OracleParser;
import com.horizon.core.common.pagehelper.parser.impl.OscarParser;
import com.horizon.core.common.pagehelper.parser.impl.PostgreSQLParser;
import com.horizon.core.common.pagehelper.parser.impl.SqlServer2012Dialect;
import com.horizon.core.common.pagehelper.parser.impl.SqlServerParser;
import com.horizon.core.common.pagehelper.parser.impl.UpbaseParser;
import com.horizon.core.common.pagehelper.regex.Matcher;
import com.horizon.core.common.pagehelper.regex.Pattern;
import com.horizon.core.common.pagehelper.sqlsource.PageProviderSqlSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractParser
implements Parser,
Constant {
    protected static final String[] HQLEXP = new String[]{"HQL_CONCAT\\s*\\([^)]+\\s*\\)", "HQL_GETSYSDATE", "HQL_GETDATE(\\(([^()]+|(?1))*+\\))", "HQL_GETTIME(\\(([^()]+|(?1))*+\\))", "HQL_SUBSTR\\s*\\([^)]+\\s*\\)", "HQL_ADDMONTH\\s*\\([^)]+\\s*\\)", "HQL_INSTR\\s*\\([^)]+\\s*\\)", "HQL_LENGTH", "HQL_REPLACE\\s*\\([^)]+\\s*\\)", "HQL_GETYM(\\(([^()]+|(?1))*+\\))", "HQL_GETYEAR(\\(([^()]+|(?1))*+\\))", "HQL_GETFULLDATE\\s*\\([^)]+\\s*\\)", "HQL_GETDATETIME(\\(([^()]+|(?1))*+\\))", "HQL_TOINT(\\(([^()]+|(?1))*+\\))", "HQL_TOCHAR(\\(([^()]+|(?1))*+\\))", "HQL_TODATETIME(\\(([^()]+|(?1))*+\\))"};
    protected static final String ARG = "\\s*\\(([^)]+\\s*)\\)";
    private static final String HQL_TMP_PARA_STR = "HQL_TMP_PARA_STR";
    private static final String HQL_TMP_PARA = "HQL_TMP_PARA";
    public static final SqlParser SQLPARSER = new SqlParser();

    public static Parser newParser(Dialect dialect) {
        AbstractParser parser = null;
        switch (dialect) {
            case mysql: 
            case mysql8: 
            case mariadb: 
            case tidb: 
            case sqlite: {
                parser = new MysqlParser();
                break;
            }
            case oracle: {
                parser = new OracleParser();
                break;
            }
            case hsqldb: {
                parser = new HsqldbParser();
                break;
            }
            case sqlserver: {
                parser = new SqlServerParser();
                break;
            }
            case sqlserver2012: {
                parser = new SqlServer2012Dialect();
                break;
            }
            case db2: {
                parser = new Db2Parser();
                break;
            }
            case postgresql: {
                parser = new PostgreSQLParser();
                break;
            }
            case highgo: {
                parser = new HighgoParser();
                break;
            }
            case informix: {
                parser = new InformixParser();
                break;
            }
            case h2: {
                parser = new H2Parser();
                break;
            }
            case gbase: {
                parser = new GBaseParser();
                break;
            }
            case gbase8s: {
                parser = new GBase8sParser();
                break;
            }
            case dm: {
                parser = new DMParser();
                break;
            }
            case kingbase: {
                parser = new KingBaseParser();
                break;
            }
            case oscar: {
                parser = new OscarParser();
                break;
            }
            case upbase: {
                parser = new UpbaseParser();
                break;
            }
            case gauss: {
                parser = new GaussParser();
                break;
            }
            default: {
                throw new RuntimeException("\u5206\u9875\u63d2\u4ef6" + (Object)((Object)dialect) + "\u65b9\u8a00\u9519\u8bef!");
            }
        }
        return parser;
    }

    protected String[] getKey() {
        return HQLEXP;
    }

    public static void main(String[] args) {
        String sql = "(HQL_TOINT(HQL_SUBSTR(A.LIMITTIME,1,HQL_LENGTH(A.LIMITTIME)-3)))";
        PostgreSQLParser parser = new PostgreSQLParser();
        System.err.println(parser.dealHqlToint(sql));
    }

    @Override
    public String dealHqlConcat(String sql) {
        Pattern p = Pattern.compile(HQLEXP[0]);
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        String formula = "";
        StringBuffer sb = new StringBuffer();
        Pattern argp = Pattern.compile(ARG);
        while (result) {
            Matcher argm = argp.matcher(m.group(0));
            if (argm.find()) {
                String[] argments = AbstractParser.splitargsByConcat(argm.group(0));
                formula = argments[0];
                int len = argments.length;
                for (int i = 1; i < len; ++i) {
                    formula = formula != null && !formula.equals("") ? formula + this.getKey()[0] + argments[i] : argments[i];
                }
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String dealHqlReplace(String sql) {
        String formula = "";
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(HQLEXP[8]);
        Pattern argp = Pattern.compile(ARG);
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        while (result) {
            String[] argments;
            Matcher argm = argp.matcher(m.group(0));
            if (argm.find() && !(argments = AbstractParser.splitargs(argm.group(0)))[1].equals("")) {
                formula = this.getKey()[8].replaceAll("HQL_TMP_SOURCE_STR", argments[1]);
                formula = formula.replaceAll("HQL_TMP_SEARCH_STR", argments[2]);
                formula = formula.replaceAll("HQL_TMP_REPLACEMENT_STR", argments[3]);
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String dealHqlInstr(String sql) {
        String formula = "";
        StringBuffer sb = new StringBuffer();
        Pattern p = Pattern.compile(HQLEXP[6]);
        Pattern argp = Pattern.compile(ARG);
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        while (result) {
            String[] argments;
            Matcher argm = argp.matcher(m.group(0));
            if (argm.find() && !(argments = AbstractParser.splitargs(argm.group(0)))[1].equals("")) {
                formula = this.getKey()[6].replaceAll(HQL_TMP_PARA_STR, argments[0]);
                formula = formula.replaceAll("HQL_TMP_PARA_SUBSTR", argments[1]);
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String dealHqlAddmonth(String sql) {
        Pattern p = Pattern.compile(HQLEXP[5]);
        Pattern argp = Pattern.compile(ARG);
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        String formula = "";
        StringBuffer sb = new StringBuffer();
        while (result) {
            String[] argments;
            Matcher argm = argp.matcher(m.group(0));
            if (argm.find() && !(argments = AbstractParser.splitargs(argm.group(0)))[1].equals("")) {
                formula = this.getKey()[5].replaceAll("HQL_TMP_PARA_DATE", argments[1]);
                formula = formula.replaceAll("HQL_TMP_PARA_NO", argments[2]);
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String dealHqlGettime(String sql) {
        return this.dealHQL(sql, HQLEXP[3], this.getKey()[3]);
    }

    @Override
    public String dealHqlGetdate(String sql) {
        return this.dealHQL(sql, HQLEXP[2], this.getKey()[2]);
    }

    @Override
    public String dealHqlGetym(String sql) {
        return this.dealHQL(sql, HQLEXP[9], this.getKey()[9]);
    }

    @Override
    public String dealHqlGetyear(String sql) {
        return this.dealHQL(sql, HQLEXP[10], this.getKey()[10]);
    }

    @Override
    public String dealHqlGetsysdate(String sql) {
        Pattern p = Pattern.compile(HQLEXP[1]);
        Matcher m = p.matcher(sql);
        if (m.find()) {
            return m.replaceAll(this.getKey()[1]);
        }
        return sql;
    }

    @Override
    public String dealHqlGetdatetime(String sql) {
        return this.dealHQL(sql, HQLEXP[12], this.getKey()[12]);
    }

    @Override
    public String dealHqToDatetime(String sql) {
        return this.dealHQL(sql, HQLEXP[15], this.getKey()[15]);
    }

    @Override
    public String dealHqlLength(String sql) {
        Pattern p = Pattern.compile(HQLEXP[7]);
        Matcher m = p.matcher(sql);
        if (m.find()) {
            return m.replaceAll(this.getKey()[7]);
        }
        return sql;
    }

    @Override
    public String dealHqlSubstr(String sql) {
        String argstr = "";
        Pattern p = Pattern.compile(HQLEXP[4]);
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        StringBuffer sb = new StringBuffer();
        while (result) {
            argstr = m.group(0).replaceAll("HQL_SUBSTR", this.getKey()[4]);
            m.appendReplacement(sb, argstr);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    @Override
    public String dealHqlToint(String sql) {
        return this.dealHQL(sql, HQLEXP[13], this.getKey()[13]);
    }

    @Override
    public String dealHqlTochar(String sql) {
        return this.dealHQL(sql, HQLEXP[14], this.getKey()[14]);
    }

    protected static String[] splitargsByConcat(String allargs) {
        ArrayList<String> srcPara = new ArrayList<String>();
        String splitexp = "\\s*[\\(,\\)]\\s*";
        String yhexp = "'[^']+'";
        Pattern p = Pattern.compile(splitexp);
        Pattern yhp = Pattern.compile(yhexp);
        Matcher m = yhp.matcher(allargs);
        boolean result = m.find();
        while (result) {
            String tmp = m.group(0);
            srcPara.add(tmp);
            result = m.find();
        }
        String[] argments = p.split(allargs);
        if (srcPara.size() > 0) {
            allargs = m.replaceAll(HQL_TMP_PARA_STR);
            int len = argments.length;
            for (int j = 0; j < len; ++j) {
                if (!argments[j].equals(HQL_TMP_PARA_STR)) continue;
                argments[j] = (String)srcPara.remove(0);
            }
        }
        return argments;
    }

    protected static String[] splitargs(String allargs) {
        if (allargs.startsWith("(")) {
            allargs = allargs.substring(1, allargs.length() - 1);
        }
        return AbstractParser.spilt(allargs);
    }

    private static String[] spilt(String a) {
        ArrayList list = Lists.newArrayList();
        int stack = 0;
        int j = 0;
        int i = 0;
        for (i = 0; i < a.length(); ++i) {
            char achar = a.charAt(i);
            if (achar == '(') {
                ++stack;
            }
            if (achar == ')') {
                --stack;
            }
            if (achar != ',' || stack > 0) continue;
            list.add(a.substring(j == 0 ? j : j + 1, i));
            j = i;
        }
        list.add(a.substring(j == 0 ? j : j + 1, i));
        return list.toArray(new String[list.size()]);
    }

    private String dealHQL(String sql, String exp, String key) {
        Pattern p = Pattern.compile(exp);
        Matcher m = p.matcher(sql);
        boolean result = m.find();
        if (!result) {
            return sql;
        }
        String formula = "";
        String argstr = "";
        StringBuffer sb = new StringBuffer();
        while (result) {
            String a = m.group(1);
            String[] argments = AbstractParser.splitargs(a);
            if (argments.length >= 1) {
                argstr = argments[0];
                formula = key.replaceAll(HQL_TMP_PARA, argstr);
            }
            m.appendReplacement(sb, formula);
            result = m.find();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, Object> processParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql) {
        HashMap<String, Object> paramMap = null;
        if (parameterObject == null) {
            paramMap = new HashMap<String, Object>();
        } else if (parameterObject instanceof Map) {
            paramMap = new HashMap();
            paramMap.putAll((Map)parameterObject);
        } else {
            paramMap = new HashMap();
            boolean hasTypeHandler = ms.getConfiguration().getTypeHandlerRegistry().hasTypeHandler(parameterObject.getClass());
            MetaObject metaObject = SystemMetaObject.forObject((Object)parameterObject);
            if (ms.getSqlSource() instanceof PageProviderSqlSource) {
                paramMap.put("_provider_object", parameterObject);
            }
            if (!hasTypeHandler) {
                for (String name : metaObject.getGetterNames()) {
                    paramMap.put(name, metaObject.getValue(name));
                }
            }
            if (boundSql.getParameterMappings() != null && boundSql.getParameterMappings().size() > 0) {
                for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                    String name = parameterMapping.getProperty();
                    if (name.equals("First_PageHelper") || name.equals("Second_PageHelper") || paramMap.get(name) != null || !hasTypeHandler && !parameterMapping.getJavaType().equals(parameterObject.getClass())) continue;
                    paramMap.put(name, parameterObject);
                    break;
                }
            }
        }
        paramMap.put("_ORIGINAL_PARAMETER_OBJECT", parameterObject);
        return paramMap;
    }

    @Override
    public boolean isSupportedMappedStatementCache() {
        return true;
    }

    @Override
    public String getCountSql(String sql) {
        return SQLPARSER.getSmartCountSql(sql);
    }

    @Override
    public abstract String getPageSql(String var1);

    @Override
    public List<ParameterMapping> getPageParameterMapping(Configuration configuration, BoundSql boundSql) {
        ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>();
        if (boundSql != null && boundSql.getParameterMappings() != null) {
            newParameterMappings.addAll(boundSql.getParameterMappings());
        }
        newParameterMappings.add(new ParameterMapping.Builder(configuration, "First_PageHelper", Integer.class).build());
        newParameterMappings.add(new ParameterMapping.Builder(configuration, "Second_PageHelper", Integer.class).build());
        return newParameterMappings;
    }

    @Override
    public Map<String, Object> setPageParameter(MappedStatement ms, Object parameterObject, BoundSql boundSql, Page<?> page) {
        return AbstractParser.processParameter(ms, parameterObject, boundSql);
    }

    protected boolean isSubPage(String sql) {
        Matcher matcher = Pattern.compile("(\\(([^()]+|(?1))*+\\))\\s*HQL_PAGE").matcher(sql);
        return matcher.find();
    }

    protected List<ParameterMapping> pageParameterMapping(Configuration configuration, BoundSql boundSql) {
        String sql = boundSql.getSql();
        Matcher matcher = Pattern.compile("(\\(([^()]+|(?1))*+\\))\\s*HQL_PAGE").matcher(sql);
        boolean result = matcher.find();
        ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>();
        if (boundSql != null && boundSql.getParameterMappings() != null) {
            newParameterMappings.addAll(boundSql.getParameterMappings());
        }
        if (!result) {
            newParameterMappings.add(new ParameterMapping.Builder(configuration, "First_PageHelper", Integer.class).build());
            newParameterMappings.add(new ParameterMapping.Builder(configuration, "Second_PageHelper", Integer.class).build());
            return newParameterMappings;
        }
        String content = matcher.group(0);
        int lastIndex = this.countParam(content, "?");
        newParameterMappings.add(lastIndex, new ParameterMapping.Builder(configuration, "First_PageHelper", Integer.class).build());
        newParameterMappings.add(lastIndex + 1, new ParameterMapping.Builder(configuration, "Second_PageHelper", Integer.class).build());
        return newParameterMappings;
    }

    protected int countParam(String content, String search) {
        int cnt = 0;
        int offset = 0;
        while ((offset = content.indexOf(search, offset)) != -1) {
            offset += search.length();
            ++cnt;
        }
        return cnt;
    }
}

