/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.Top;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;

public class SqlServer {
    protected static final Map<String, String> CACHE = new ConcurrentHashMap<String, String>();
    protected static final String START_ROW = String.valueOf(Long.MIN_VALUE);
    protected static final String PAGE_SIZE = String.valueOf(Long.MAX_VALUE);
    protected static final String WRAP_TABLE = "WRAP_OUTER_TABLE";
    protected static final String PAGE_TABLE_NAME = "PAGE_TABLE_ALIAS";
    public static final Alias PAGE_TABLE_ALIAS = new Alias("PAGE_TABLE_ALIAS");
    protected static final String PAGE_ROW_NUMBER = "PAGE_ROW_NUMBER";
    protected static final Column PAGE_ROW_NUMBER_COLUMN = new Column("PAGE_ROW_NUMBER");
    protected static final Top TOP100_PERCENT = new Top();
    private static final String regex_Replace_PreffixColumn_Alias = "[^\\s,]+\\.";
    private static final String COMMA = ",";
    private static final String AS = " as ";
    private static final String SPACE = " ";
    private static final String AS2 = ")as ";
    private static final String rightKh = ")";
    private static final String regexAS = "\\s+as\\s+";
    private static final String regexAS2 = "\\)\\s*as\\s+";
    private static final String regexRightKh = "\\)\\s*";
    private static final String STAR = "*";

    public String convertToPageSql(String sql, int offset, int limit) {
        String pageSql = CACHE.get(sql);
        if (pageSql == null) {
            Statement stmt;
            try {
                stmt = CCJSqlParserUtil.parse((String)sql);
            }
            catch (Throwable e) {
                throw new RuntimeException("\u4e0d\u652f\u6301\u8be5SQL\u8f6c\u6362\u4e3a\u5206\u9875\u67e5\u8be2!");
            }
            if (!(stmt instanceof Select)) {
                throw new RuntimeException("\u5206\u9875\u8bed\u53e5\u5fc5\u987b\u662fSelect\u67e5\u8be2!");
            }
            Select pageSelect = this.getPageSelect((Select)stmt);
            pageSql = pageSelect.toString();
            CACHE.put(sql, pageSql);
        }
        pageSql = pageSql.replace(START_ROW, String.valueOf(offset));
        pageSql = pageSql.replace(PAGE_SIZE, String.valueOf(limit));
        return pageSql;
    }

    protected Select getPageSelect(Select select) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof SetOperationList) {
            selectBody = this.wrapSetOperationList((SetOperationList)selectBody);
        }
        if (((PlainSelect)selectBody).getTop() != null) {
            throw new RuntimeException("\u88ab\u5206\u9875\u7684\u8bed\u53e5\u5df2\u7ecf\u5305\u542b\u4e86Top\uff0c\u4e0d\u80fd\u518d\u901a\u8fc7\u5206\u9875\u63d2\u4ef6\u8fdb\u884c\u5206\u9875\u67e5\u8be2!");
        }
        List<SelectItem> selectItems = this.getSelectItems((PlainSelect)selectBody);
        PlainSelect newPainSelect = this.addRowNumber((PlainSelect)selectBody);
        this.processSelectBody((SelectBody)newPainSelect, 0);
        Select newSelect = new Select();
        PlainSelect newSelectBody = new PlainSelect();
        Top top = new Top();
        top.setRowCount(Long.MAX_VALUE);
        newSelectBody.setTop(top);
        ArrayList<OrderByElement> orderByElements = new ArrayList<OrderByElement>();
        OrderByElement orderByElement = new OrderByElement();
        orderByElement.setExpression((Expression)PAGE_ROW_NUMBER_COLUMN);
        orderByElements.add(orderByElement);
        newSelectBody.setOrderByElements(orderByElements);
        GreaterThan greaterThan = new GreaterThan();
        greaterThan.setLeftExpression((Expression)PAGE_ROW_NUMBER_COLUMN);
        greaterThan.setRightExpression((Expression)new LongValue(Long.MIN_VALUE));
        newSelectBody.setWhere((Expression)greaterThan);
        newSelectBody.setSelectItems(selectItems);
        SubSelect fromItem = new SubSelect();
        fromItem.setSelectBody((SelectBody)newPainSelect);
        fromItem.setAlias(PAGE_TABLE_ALIAS);
        newSelectBody.setFromItem((FromItem)fromItem);
        newSelect.setSelectBody((SelectBody)newSelectBody);
        if (this.isNotEmptyList(select.getWithItemsList())) {
            newSelect.setWithItemsList(select.getWithItemsList());
        }
        return newSelect;
    }

    protected SelectBody wrapSetOperationList(SetOperationList setOperationList) {
        SelectBody setSelectBody = (SelectBody)setOperationList.getSelects().get(setOperationList.getSelects().size() - 1);
        if (!(setSelectBody instanceof PlainSelect)) {
            throw new RuntimeException("\u76ee\u524d\u65e0\u6cd5\u5904\u7406\u8be5SQL\uff0c\u60a8\u53ef\u4ee5\u5c06\u8be5SQL\u53d1\u9001\u7ed9abel533@gmail.com\u534f\u52a9\u4f5c\u8005\u89e3\u51b3!");
        }
        PlainSelect plainSelect = (PlainSelect)setSelectBody;
        PlainSelect selectBody = new PlainSelect();
        List<SelectItem> selectItems = this.getSelectItems(plainSelect);
        selectBody.setSelectItems(selectItems);
        SubSelect fromItem = new SubSelect();
        fromItem.setSelectBody((SelectBody)setOperationList);
        fromItem.setAlias(new Alias(WRAP_TABLE));
        selectBody.setFromItem((FromItem)fromItem);
        if (this.isNotEmptyList(plainSelect.getOrderByElements())) {
            selectBody.setOrderByElements(plainSelect.getOrderByElements());
            plainSelect.setOrderByElements(null);
        }
        return selectBody;
    }

    protected List<SelectItem> getSelectItems(PlainSelect plainSelect) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (SelectItem selectItem : plainSelect.getSelectItems()) {
            if (selectItem instanceof SelectExpressionItem) {
                Column column;
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                if (selectExpressionItem.getAlias() != null) {
                    column = new Column(selectExpressionItem.getAlias().getName());
                    SelectExpressionItem expressionItem = new SelectExpressionItem((Expression)column);
                    selectItems.add((SelectItem)expressionItem);
                    continue;
                }
                if (selectExpressionItem.getExpression() instanceof Column) {
                    column = (Column)selectExpressionItem.getExpression();
                    SelectExpressionItem item = null;
                    if (column.getTable() != null) {
                        Column newColumn = new Column(column.getColumnName());
                        item = new SelectExpressionItem((Expression)newColumn);
                        selectItems.add((SelectItem)item);
                        continue;
                    }
                    selectItems.add(selectItem);
                    continue;
                }
                selectItems.add(selectItem);
                continue;
            }
            if (selectItem instanceof AllTableColumns) {
                selectItems.add((SelectItem)new AllColumns());
                continue;
            }
            selectItems.add(selectItem);
        }
        return selectItems;
    }

    protected PlainSelect addRowNumber(PlainSelect plainSelect) {
        StringBuilder orderByBuilder = new StringBuilder();
        orderByBuilder.append("ROW_NUMBER() OVER (");
        if (this.isNotEmptyList(plainSelect.getOrderByElements())) {
            orderByBuilder.append("ORDER BY " + this.getParsedOrderByColumns(PlainSelect.getStringList((List)plainSelect.getOrderByElements(), (boolean)true, (boolean)false)));
        } else {
            String orderBy = "ORDER BY ";
            List selectItems = plainSelect.getSelectItems();
            StringBuffer selectStr = new StringBuffer();
            for (SelectItem selectItem : selectItems) {
                selectStr.append(COMMA + selectItem.toString());
            }
            orderByBuilder.append(orderBy).append(this.getParsedOrderByColumns(selectStr.toString().substring(1)));
        }
        if (this.isNotEmptyList(plainSelect.getOrderByElements())) {
            plainSelect.setOrderByElements(null);
        }
        orderByBuilder.append(") ");
        orderByBuilder.append(PAGE_ROW_NUMBER);
        List<SelectItem> selectItems = this.getSelectItems(plainSelect);
        PlainSelect newSelect = new PlainSelect();
        newSelect.setSelectItems(selectItems);
        SubSelect fromItem = new SubSelect();
        fromItem.setSelectBody((SelectBody)plainSelect);
        fromItem.setAlias(new Alias(WRAP_TABLE));
        newSelect.setFromItem((FromItem)fromItem);
        Column orderByColumn = new Column(orderByBuilder.toString());
        newSelect.getSelectItems().add(0, new SelectExpressionItem((Expression)orderByColumn));
        return newSelect;
    }

    protected void processSelectBody(SelectBody selectBody, int level) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody, level + 1);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                this.processSelectBody(withItem.getSelectBody(), level + 1);
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                List plainSelects = operationList.getSelects();
                for (SelectBody plainSelect : plainSelects) {
                    this.processSelectBody(plainSelect, level + 1);
                }
            }
        }
    }

    protected void processPlainSelect(PlainSelect plainSelect, int level) {
        if (level > 1 && this.isNotEmptyList(plainSelect.getOrderByElements()) && plainSelect.getTop() == null) {
            plainSelect.setTop(TOP100_PERCENT);
        }
        if (plainSelect.getFromItem() != null) {
            this.processFromItem(plainSelect.getFromItem(), level + 1);
        }
        if (plainSelect.getJoins() != null && plainSelect.getJoins().size() > 0) {
            List joins = plainSelect.getJoins();
            for (Join join : joins) {
                if (join.getRightItem() == null) continue;
                this.processFromItem(join.getRightItem(), level + 1);
            }
        }
    }

    protected void processFromItem(FromItem fromItem, int level) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoin() != null && subJoin.getJoin().getRightItem() != null) {
                this.processFromItem(subJoin.getJoin().getRightItem(), level + 1);
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft(), level + 1);
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody(), level + 1);
            }
        } else if (!(fromItem instanceof ValuesList) && fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody(), level + 1);
        }
    }

    public boolean isNotEmptyList(List<?> list) {
        return list != null && list.size() != 0;
    }

    private String getParsedOrderByColumns(String selectColumns) {
        if (STAR.equals(selectColumns)) {
            return "id";
        }
        selectColumns = selectColumns.replaceAll(regex_Replace_PreffixColumn_Alias, "");
        if ((selectColumns = selectColumns.trim()).indexOf(COMMA) > 0) {
            String[] columns = selectColumns.split("\\,");
            StringBuffer sbColumns = new StringBuffer();
            int len = columns.length;
            for (int i = 0; i < len; ++i) {
                String tmpColumn;
                String[] cols;
                String column = columns[i].trim().toLowerCase();
                if (column.lastIndexOf(AS) > 0) {
                    cols = column.split(regexAS);
                    tmpColumn = cols[cols.length - 1];
                } else if (column.lastIndexOf(AS2) > 0) {
                    cols = column.split(regexAS2);
                    tmpColumn = cols[cols.length - 1];
                } else if (column.lastIndexOf(rightKh) > 0) {
                    cols = column.split(regexRightKh);
                    tmpColumn = cols[cols.length - 1].trim();
                } else if (column.lastIndexOf(SPACE) > 0) {
                    cols = column.split(SPACE);
                    tmpColumn = cols[cols.length - 1];
                } else {
                    tmpColumn = column;
                }
                if (sbColumns.length() > 0) {
                    sbColumns.append(COMMA);
                }
                sbColumns.append(tmpColumn);
            }
            selectColumns = sbColumns.toString();
        }
        return selectColumns;
    }

    public static void main(String[] args) {
        SqlServer sqlServer = new SqlServer();
        String originalSql = "select t.aaa a, t.bbb b from tal t order by a";
        System.out.println(sqlServer.convertToPageSql(originalSql, 1, 10));
    }

    static {
        TOP100_PERCENT.setRowCount(100L);
        TOP100_PERCENT.setPercentage(true);
    }
}

