/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper;

import com.horizon.apache.ibatis.builder.StaticSqlSource;
import com.horizon.apache.ibatis.builder.annotation.ProviderSqlSource;
import com.horizon.apache.ibatis.mapping.BoundSql;
import com.horizon.apache.ibatis.mapping.MappedStatement;
import com.horizon.apache.ibatis.mapping.SqlSource;
import com.horizon.apache.ibatis.plugin.Invocation;
import com.horizon.apache.ibatis.reflection.MetaObject;
import com.horizon.apache.ibatis.reflection.SystemMetaObject;
import com.horizon.apache.ibatis.scripting.defaults.RawSqlSource;
import com.horizon.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import com.horizon.apache.ibatis.session.RowBounds;
import com.horizon.core.common.pagehelper.Constant;
import com.horizon.core.common.pagehelper.Dialect;
import com.horizon.core.common.pagehelper.MSUtils;
import com.horizon.core.common.pagehelper.Page;
import com.horizon.core.common.pagehelper.SqlUtilConfig;
import com.horizon.core.common.pagehelper.StringUtil;
import com.horizon.core.common.pagehelper.parser.Parser;
import com.horizon.core.common.pagehelper.parser.impl.AbstractParser;
import com.horizon.core.common.pagehelper.sqlsource.PageDynamicSqlSource;
import com.horizon.core.common.pagehelper.sqlsource.PageProviderSqlSource;
import com.horizon.core.common.pagehelper.sqlsource.PageRawSqlSource;
import com.horizon.core.common.pagehelper.sqlsource.PageSqlSource;
import com.horizon.core.common.pagehelper.sqlsource.PageStaticSqlSource;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SqlUtil
implements Constant {
    private static final ThreadLocal<Page> LOCAL_PAGE = new ThreadLocal();
    private static Map<String, String> PARAMS = new HashMap<String, String>(5);
    private static Boolean HAS_REQUEST;
    private static Class<?> REQUEST_CLASS;
    private static Method GET_PARAMETER_MAP;
    private static final Map<String, MappedStatement> msCountMap;
    private boolean offsetAsPageNum = false;
    private boolean rowBoundsWithCount = false;
    private boolean pageSizeZero = false;
    private boolean reasonable = false;
    private Parser parser;
    private boolean supportMethodsArguments = false;

    public SqlUtil(String strDialect) {
        if (strDialect == null || "".equals(strDialect)) {
            throw new IllegalArgumentException("Mybatis\u5206\u9875\u63d2\u4ef6\u65e0\u6cd5\u83b7\u53d6dialect\u53c2\u6570!");
        }
        Exception exception = null;
        try {
            Dialect dialect = Dialect.of(strDialect);
            this.parser = AbstractParser.newParser(dialect);
        }
        catch (Exception e) {
            exception = e;
            try {
                Class<?> parserClass = Class.forName(strDialect);
                if (Parser.class.isAssignableFrom(parserClass)) {
                    this.parser = (Parser)parserClass.newInstance();
                }
            }
            catch (ClassNotFoundException ex) {
                exception = ex;
            }
            catch (InstantiationException ex) {
                exception = ex;
            }
            catch (IllegalAccessException ex) {
                exception = ex;
            }
        }
        if (this.parser == null) {
            throw new RuntimeException(exception);
        }
    }

    public static Boolean getCount() {
        Page page = SqlUtil.getLocalPage();
        if (page != null) {
            return page.getCountSignal();
        }
        return null;
    }

    public static <T> Page<T> getLocalPage() {
        return LOCAL_PAGE.get();
    }

    public static void setLocalPage(Page page) {
        LOCAL_PAGE.set(page);
    }

    public static void clearLocalPage() {
        LOCAL_PAGE.remove();
    }

    public static <T> Page<T> getPageFromObject(Object params) {
        Object pageSizeZero;
        Object reasonable;
        int pageSize;
        int pageNum;
        MetaObject paramsObject = null;
        if (params == null) {
            throw new NullPointerException("\u65e0\u6cd5\u83b7\u53d6\u5206\u9875\u67e5\u8be2\u53c2\u6570!");
        }
        if (HAS_REQUEST.booleanValue() && REQUEST_CLASS.isAssignableFrom(params.getClass())) {
            try {
                paramsObject = SystemMetaObject.forObject((Object)GET_PARAMETER_MAP.invoke(params, new Object[0]));
            }
            catch (Exception e) {}
        } else {
            paramsObject = SystemMetaObject.forObject((Object)params);
        }
        if (paramsObject == null) {
            throw new NullPointerException("\u5206\u9875\u67e5\u8be2\u53c2\u6570\u5904\u7406\u5931\u8d25!");
        }
        Object orderBy = SqlUtil.getParamValue(paramsObject, "orderBy", false);
        boolean hasOrderBy = false;
        if (orderBy != null && orderBy.toString().length() > 0) {
            hasOrderBy = true;
        }
        try {
            Object pageNumTmp = SqlUtil.getParamValue(paramsObject, "pageNum", !hasOrderBy);
            Object pageSizeTmp = SqlUtil.getParamValue(paramsObject, "pageSize", !hasOrderBy);
            if (pageNumTmp == null || pageSizeTmp == null) {
                Page page = new Page();
                page.setOrderBy(orderBy.toString());
                page.setOrderByOnly(true);
                return page;
            }
            pageNum = Integer.parseInt(String.valueOf(pageNumTmp));
            pageSize = Integer.parseInt(String.valueOf(pageSizeTmp));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57\u7c7b\u578b!");
        }
        Page page = new Page(pageNum, pageSize);
        Object countTmp = SqlUtil.getParamValue(paramsObject, "count", false);
        if (countTmp != null) {
            page.setCount(Boolean.valueOf(String.valueOf(countTmp)));
        }
        if (hasOrderBy) {
            page.setOrderBy(orderBy.toString());
        }
        if ((reasonable = SqlUtil.getParamValue(paramsObject, "reasonable", false)) != null) {
            page.setReasonable(Boolean.valueOf(String.valueOf(reasonable)));
        }
        if ((pageSizeZero = SqlUtil.getParamValue(paramsObject, "pageSizeZero", false)) != null) {
            page.setPageSizeZero(Boolean.valueOf(String.valueOf(pageSizeZero)));
        }
        return page;
    }

    public static Object getParamValue(MetaObject paramsObject, String paramName, boolean required) {
        Object value = null;
        if (paramsObject.hasGetter(PARAMS.get(paramName))) {
            value = paramsObject.getValue(PARAMS.get(paramName));
        }
        if (value != null && value.getClass().isArray()) {
            Object[] values = (Object[])value;
            value = values.length == 0 ? null : values[0];
        }
        if (required && value == null) {
            throw new RuntimeException("\u5206\u9875\u67e5\u8be2\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570:" + PARAMS.get(paramName));
        }
        return value;
    }

    public boolean isPageSqlSource(MappedStatement ms) {
        return ms.getSqlSource() instanceof PageSqlSource;
    }

    public void processMappedStatement(MappedStatement ms) throws Throwable {
        PageSqlSource pageSqlSource;
        SqlSource sqlSource = ms.getSqlSource();
        MetaObject msObject = SystemMetaObject.forObject((Object)ms);
        if (sqlSource instanceof StaticSqlSource) {
            pageSqlSource = new PageStaticSqlSource((StaticSqlSource)sqlSource);
        } else if (sqlSource instanceof RawSqlSource) {
            pageSqlSource = new PageRawSqlSource((RawSqlSource)sqlSource);
        } else if (sqlSource instanceof ProviderSqlSource) {
            pageSqlSource = new PageProviderSqlSource((ProviderSqlSource)sqlSource);
        } else if (sqlSource instanceof DynamicSqlSource) {
            pageSqlSource = new PageDynamicSqlSource((DynamicSqlSource)sqlSource);
        } else {
            throw new RuntimeException("\u65e0\u6cd5\u5904\u7406\u8be5\u7c7b\u578b[" + sqlSource.getClass() + "]\u7684SqlSource");
        }
        msObject.setValue("sqlSource", (Object)pageSqlSource);
        msCountMap.put(ms.getId(), MSUtils.newCountMappedStatement(ms));
    }

    public Page getPage(Object[] args) {
        Page<Object> page = SqlUtil.getLocalPage();
        if (page == null || page.isOrderByOnly()) {
            Page oldPage = page;
            if ((args[2] == null || args[2] == RowBounds.DEFAULT) && page != null) {
                return oldPage;
            }
            if (args[2] instanceof RowBounds && args[2] != RowBounds.DEFAULT) {
                RowBounds rowBounds = (RowBounds)args[2];
                if (this.offsetAsPageNum) {
                    page = new Page(rowBounds.getOffset(), rowBounds.getLimit(), this.rowBoundsWithCount);
                } else {
                    page = new Page(new int[]{rowBounds.getOffset(), rowBounds.getLimit()}, this.rowBoundsWithCount);
                    page.setReasonable(false);
                }
            } else {
                try {
                    page = SqlUtil.getPageFromObject(args[1]);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (oldPage != null) {
                page.setOrderBy(oldPage.getOrderBy());
            }
            SqlUtil.setLocalPage(page);
        }
        if (page.getReasonable() == null) {
            page.setReasonable(this.reasonable);
        }
        if (page.getPageSizeZero() == null) {
            page.setPageSizeZero(this.pageSizeZero);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processPage(Invocation invocation) throws Throwable {
        try {
            Object result;
            Object object = result = this.processPageIn(invocation);
            return object;
        }
        finally {
            SqlUtil.clearLocalPage();
        }
    }

    private Object processPageIn(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        Page page = null;
        if (this.supportMethodsArguments) {
            page = this.getPage(args);
        }
        RowBounds rowBounds = (RowBounds)args[2];
        if (this.supportMethodsArguments && page == null || !this.supportMethodsArguments && SqlUtil.getLocalPage() == null && rowBounds == RowBounds.DEFAULT) {
            return invocation.proceed();
        }
        if (!this.supportMethodsArguments && page == null) {
            page = this.getPage(args);
        }
        return this.doProcessPage(invocation, page, args);
    }

    private boolean isQueryOnly(Page page) {
        return page.isOrderByOnly() || page.getPageSizeZero() != null && page.getPageSizeZero() != false && page.getPageSize() == 0;
    }

    private Page doQueryOnly(Page page, Invocation invocation) throws Throwable {
        page.setCountSignal(null);
        Object result = invocation.proceed();
        page.addAll((List)result);
        page.setPageNum(1);
        page.setPageSize(page.size());
        page.setTotal(page.size());
        return page;
    }

    private Page doProcessPage(Invocation invocation, Page page, Object[] args) throws Throwable {
        RowBounds rowBounds = (RowBounds)args[2];
        MappedStatement ms = (MappedStatement)args[0];
        if (!this.isPageSqlSource(ms)) {
            this.processMappedStatement(ms);
        }
        ((PageSqlSource)ms.getSqlSource()).setParser(this.parser);
        args[2] = RowBounds.DEFAULT;
        if (this.isQueryOnly(page)) {
            return this.doQueryOnly(page, invocation);
        }
        if (page.isCount()) {
            page.setCountSignal(Boolean.TRUE);
            args[0] = msCountMap.get(ms.getId());
            Object result = invocation.proceed();
            args[0] = ms;
            page.setTotal(((Integer)((List)result).get(0)).intValue());
            if (page.getTotal() == 0L) {
                return page;
            }
        } else {
            page.setTotal(-1L);
        }
        if (page.getPageSize() > 0 && (rowBounds == RowBounds.DEFAULT && page.getPageNum() > 0 || rowBounds != RowBounds.DEFAULT)) {
            page.setCountSignal(null);
            BoundSql boundSql = ms.getBoundSql(args[1]);
            args[1] = this.parser.setPageParameter(ms, args[1], boundSql, page);
            page.setCountSignal(Boolean.FALSE);
            Object result = invocation.proceed();
            page.addAll((List)result);
        }
        return page;
    }

    public void setOffsetAsPageNum(boolean offsetAsPageNum) {
        this.offsetAsPageNum = offsetAsPageNum;
    }

    public void setRowBoundsWithCount(boolean rowBoundsWithCount) {
        this.rowBoundsWithCount = rowBoundsWithCount;
    }

    public void setPageSizeZero(boolean pageSizeZero) {
        this.pageSizeZero = pageSizeZero;
    }

    public void setReasonable(boolean reasonable) {
        this.reasonable = reasonable;
    }

    public void setSupportMethodsArguments(boolean supportMethodsArguments) {
        this.supportMethodsArguments = supportMethodsArguments;
    }

    public void setParams(String params) {
        PARAMS.put("pageNum", "pageNum");
        PARAMS.put("pageSize", "pageSize");
        PARAMS.put("count", "countSql");
        PARAMS.put("orderBy", "orderBy");
        PARAMS.put("reasonable", "reasonable");
        PARAMS.put("pageSizeZero", "pageSizeZero");
        if (StringUtil.isNotEmpty(params)) {
            String[] ps;
            for (String s : ps = params.split("[;|,|&]")) {
                String[] ss = s.split("[=|:]");
                if (ss.length != 2) continue;
                PARAMS.put(ss[0], ss[1]);
            }
        }
    }

    public void setProperties(Properties p) {
        String offsetAsPageNum = p.getProperty("offsetAsPageNum");
        this.offsetAsPageNum = Boolean.parseBoolean(offsetAsPageNum);
        String rowBoundsWithCount = p.getProperty("rowBoundsWithCount");
        this.rowBoundsWithCount = Boolean.parseBoolean(rowBoundsWithCount);
        String pageSizeZero = p.getProperty("pageSizeZero");
        this.pageSizeZero = Boolean.parseBoolean(pageSizeZero);
        String reasonable = p.getProperty("reasonable");
        this.reasonable = Boolean.parseBoolean(reasonable);
        String supportMethodsArguments = p.getProperty("supportMethodsArguments");
        this.supportMethodsArguments = Boolean.parseBoolean(supportMethodsArguments);
        this.setParams(p.getProperty("params"));
    }

    public void setSqlUtilConfig(SqlUtilConfig config) {
        this.offsetAsPageNum = config.isOffsetAsPageNum();
        this.rowBoundsWithCount = config.isRowBoundsWithCount();
        this.pageSizeZero = config.isPageSizeZero();
        this.reasonable = config.isReasonable();
        this.supportMethodsArguments = config.isSupportMethodsArguments();
        this.setParams(config.getParams());
    }

    public String parse(String sql) {
        if (this.parser == null) {
            return sql;
        }
        if (sql.indexOf("HQL_CONCAT") > 0) {
            sql = this.parser.dealHqlConcat(sql);
        }
        if (sql.indexOf("HQL_REPLACE") > 0) {
            sql = this.parser.dealHqlReplace(sql);
        }
        if (sql.indexOf("HQL_INSTR") > 0) {
            sql = this.parser.dealHqlInstr(sql);
        }
        if (sql.indexOf("HQL_ADDMONTH") > 0) {
            sql = this.parser.dealHqlAddmonth(sql);
        }
        if (sql.indexOf("HQL_GETTIME") > 0) {
            sql = this.parser.dealHqlGettime(sql);
        }
        if (sql.indexOf("HQL_GETDATE") > 0) {
            sql = this.parser.dealHqlGetdate(sql);
        }
        if (sql.indexOf("HQL_GETYM") > 0) {
            sql = this.parser.dealHqlGetym(sql);
        }
        if (sql.indexOf("HQL_GETYEAR") > 0) {
            sql = this.parser.dealHqlGetyear(sql);
        }
        if (sql.indexOf("HQL_GETDATETIME") > 0) {
            sql = this.parser.dealHqlGetdatetime(sql);
        }
        if (sql.indexOf("HQL_GETSYSDATE") > 0) {
            sql = this.parser.dealHqlGetsysdate(sql);
        }
        if (sql.indexOf("HQL_LENGTH") > 0) {
            sql = this.parser.dealHqlLength(sql);
        }
        if (sql.indexOf("HQL_SUBSTR") > 0) {
            sql = this.parser.dealHqlSubstr(sql);
        }
        if (sql.indexOf("HQL_TOINT") > 0) {
            sql = this.parser.dealHqlToint(sql);
        }
        if (sql.indexOf("HQL_TOCHAR") > 0) {
            sql = this.parser.dealHqlTochar(sql);
        }
        if (sql.indexOf("HQL_TODATETIME") > 0) {
            sql = this.parser.dealHqToDatetime(sql);
        }
        return sql;
    }

    static {
        msCountMap = new ConcurrentHashMap<String, MappedStatement>();
        try {
            REQUEST_CLASS = Class.forName("javax.servlet.ServletRequest");
            GET_PARAMETER_MAP = REQUEST_CLASS.getMethod("getParameterMap", new Class[0]);
            HAS_REQUEST = true;
        }
        catch (Throwable e) {
            HAS_REQUEST = false;
        }
    }
}

