/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.pagehelper;

import com.horizon.apache.ibatis.executor.Executor;
import com.horizon.apache.ibatis.executor.statement.RoutingStatementHandler;
import com.horizon.apache.ibatis.executor.statement.StatementHandler;
import com.horizon.apache.ibatis.mapping.BoundSql;
import com.horizon.apache.ibatis.mapping.MappedStatement;
import com.horizon.apache.ibatis.plugin.Interceptor;
import com.horizon.apache.ibatis.plugin.Intercepts;
import com.horizon.apache.ibatis.plugin.Invocation;
import com.horizon.apache.ibatis.plugin.Plugin;
import com.horizon.apache.ibatis.plugin.Signature;
import com.horizon.apache.ibatis.session.ResultHandler;
import com.horizon.apache.ibatis.session.RowBounds;
import com.horizon.core.common.pagehelper.Dialect;
import com.horizon.core.common.pagehelper.ISelect;
import com.horizon.core.common.pagehelper.Page;
import com.horizon.core.common.pagehelper.SqlUtil;
import com.horizon.core.common.pagehelper.SqlUtilConfig;
import com.horizon.core.common.pagehelper.StringUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PageHelper
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageHelper.class);
    private SqlUtil sqlUtil;
    private Properties properties;
    private SqlUtilConfig sqlUtilConfig;
    private boolean autoDialect = true;
    private boolean autoRuntimeDialect;
    private boolean closeConn = true;
    private Map<String, SqlUtil> urlSqlUtilMap = new ConcurrentHashMap<String, SqlUtil>();

    public static long count(ISelect select) {
        Page page = PageHelper.startPage(1, -1, true);
        select.doSelect();
        return page.getTotal();
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize) {
        return PageHelper.startPage(pageNum, pageSize, true);
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, boolean count) {
        return PageHelper.startPage(pageNum, pageSize, count, null);
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, String orderBy) {
        Page<E> page = PageHelper.startPage(pageNum, pageSize);
        page.setOrderBy(orderBy);
        return page;
    }

    public static <E> Page<E> offsetPage(int offset, int limit) {
        return PageHelper.offsetPage(offset, limit, true);
    }

    public static <E> Page<E> offsetPage(int offset, int limit, boolean count) {
        Page page = new Page(new int[]{offset, limit}, count);
        Page oldPage = SqlUtil.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        SqlUtil.setLocalPage(page);
        return page;
    }

    public static <E> Page<E> offsetPage(int offset, int limit, String orderBy) {
        Page<E> page = PageHelper.offsetPage(offset, limit);
        page.setOrderBy(orderBy);
        return page;
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, boolean count, Boolean reasonable) {
        return PageHelper.startPage(pageNum, pageSize, count, reasonable, null);
    }

    public static <E> Page<E> startPage(int pageNum, int pageSize, boolean count, Boolean reasonable, Boolean pageSizeZero) {
        Page page = new Page(pageNum, pageSize, count);
        page.setReasonable(reasonable);
        page.setPageSizeZero(pageSizeZero);
        Page oldPage = SqlUtil.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        SqlUtil.setLocalPage(page);
        return page;
    }

    public static <E> Page<E> startPage(Object params) {
        Page page = SqlUtil.getPageFromObject(params);
        Page oldPage = SqlUtil.getLocalPage();
        if (oldPage != null && oldPage.isOrderByOnly()) {
            page.setOrderBy(oldPage.getOrderBy());
        }
        SqlUtil.setLocalPage(page);
        return page;
    }

    public static void orderBy(String orderBy) {
        Page<Object> page = SqlUtil.getLocalPage();
        if (page != null) {
            page.setOrderBy(orderBy);
        } else {
            page = new Page();
            page.setOrderBy(orderBy);
            page.setOrderByOnly(true);
            SqlUtil.setLocalPage(page);
        }
    }

    public static String getOrderBy() {
        Page page = SqlUtil.getLocalPage();
        if (page != null) {
            String orderBy = page.getOrderBy();
            if (StringUtil.isEmpty(orderBy)) {
                return null;
            }
            return orderBy;
        }
        return null;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        if (invocation.getTarget() instanceof RoutingStatementHandler) {
            RoutingStatementHandler statementHandler = (RoutingStatementHandler)invocation.getTarget();
            BoundSql boundSql = statementHandler.getBoundSql();
            String url = ((Connection)invocation.getArgs()[0]).getMetaData().getURL();
            SqlUtil sqlUtil = this.getSqlUtilByUrl(url);
            String sql = boundSql.getSql();
            String newSql = sqlUtil.parse(sql);
            FieldUtils.writeField((Field)FieldUtils.getDeclaredField(boundSql.getClass(), (String)"sql", (boolean)true), (Object)boundSql, (Object)newSql);
        }
        if (invocation.getTarget() instanceof Executor) {
            if (this.autoRuntimeDialect) {
                SqlUtil sqlUtil = this.getSqlUtil(invocation);
                return sqlUtil.processPage(invocation);
            }
            if (this.autoDialect) {
                this.initSqlUtil(invocation);
            }
            return this.sqlUtil.processPage(invocation);
        }
        return invocation.proceed();
    }

    public synchronized void initSqlUtil(Invocation invocation) {
        if (this.sqlUtil == null) {
            this.sqlUtil = this.getSqlUtil(invocation);
            if (!this.autoRuntimeDialect) {
                this.properties = null;
                this.sqlUtilConfig = null;
            }
            this.autoDialect = false;
        }
    }

    public String getUrl(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                try {
                    if (this.closeConn) {
                        conn.close();
                    }
                }
                catch (SQLException e) {}
            }
        }
    }

    public SqlUtil getSqlUtil(Invocation invocation) {
        MappedStatement ms = (MappedStatement)invocation.getArgs()[0];
        DataSource dataSource = ms.getConfiguration().getEnvironment().getDataSource();
        String url = this.getUrl(dataSource);
        return this.getSqlUtilByUrl(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlUtil getSqlUtilByUrl(String url) {
        if (this.urlSqlUtilMap.containsKey(url)) {
            return this.urlSqlUtilMap.get(url);
        }
        ReentrantLock lock = new ReentrantLock();
        try {
            lock.lock();
            if (this.urlSqlUtilMap.containsKey(url)) {
                SqlUtil sqlUtil = this.urlSqlUtilMap.get(url);
                return sqlUtil;
            }
            if (StringUtil.isEmpty(url)) {
                throw new RuntimeException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6jdbcUrl\uff0c\u8bf7\u5728\u5206\u9875\u63d2\u4ef6\u4e2d\u914d\u7f6edialect\u53c2\u6570!");
            }
            String dialect = Dialect.fromJdbcUrl(url);
            if (dialect == null) {
                throw new RuntimeException("\u65e0\u6cd5\u81ea\u52a8\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u8bf7\u901a\u8fc7dialect\u53c2\u6570\u6307\u5b9a!");
            }
            SqlUtil sqlUtil = new SqlUtil(dialect);
            if (this.properties != null) {
                sqlUtil.setProperties(this.properties);
            } else if (this.sqlUtilConfig != null) {
                sqlUtil.setSqlUtilConfig(this.sqlUtilConfig);
            }
            this.urlSqlUtilMap.put(url, sqlUtil);
            SqlUtil sqlUtil2 = sqlUtil;
            return sqlUtil2;
        }
        finally {
            lock.unlock();
        }
    }

    public Object plugin(Object target) {
        if (target instanceof Executor || target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    private void checkVersion() {
        try {
            Class.forName("com.horizon.apache.ibatis.scripting.xmltags.SqlNode");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u60a8\u4f7f\u7528\u7684MyBatis\u7248\u672c\u592a\u4f4e\uff0cMyBatis\u5206\u9875\u63d2\u4ef6PageHelper\u652f\u6301MyBatis3.2.0\u53ca\u4ee5\u4e0a\u7248\u672c!");
        }
    }

    public void setProperties(Properties p) {
        this.checkVersion();
        String closeConn = p.getProperty("closeConn");
        this.closeConn = Boolean.parseBoolean(closeConn);
        String dialect = p.getProperty("dialect");
        String runtimeDialect = p.getProperty("autoRuntimeDialect");
        if (StringUtil.isNotEmpty(runtimeDialect) && runtimeDialect.equalsIgnoreCase("TRUE")) {
            this.autoRuntimeDialect = true;
            this.autoDialect = false;
            this.properties = p;
        } else if (StringUtil.isEmpty(dialect)) {
            this.autoDialect = true;
            this.properties = p;
        } else {
            this.autoDialect = false;
            this.sqlUtil = new SqlUtil(dialect);
            this.sqlUtil.setProperties(p);
        }
    }

    public void setSqlUtilConfig(SqlUtilConfig config) {
        this.checkVersion();
        this.closeConn = config.isCloseConn();
        if (config.isAutoRuntimeDialect()) {
            this.autoRuntimeDialect = true;
            this.autoDialect = false;
            this.sqlUtilConfig = config;
        } else if (StringUtil.isEmpty(config.getDialect())) {
            this.autoDialect = true;
            this.sqlUtilConfig = config;
        } else {
            this.autoDialect = false;
            this.sqlUtil = new SqlUtil(config.getDialect());
            this.sqlUtil.setSqlUtilConfig(config);
        }
    }
}

