/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.common.controller;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.horizon.common.base.Objects;
import com.horizon.common.base.Splitter;
import com.horizon.common.collect.Maps;
import com.horizon.core.common.entity.ViewData;
import com.horizon.core.common.pagehelper.PageHelper;
import com.horizon.core.common.service.ICoreService;
import com.horizon.utils.DateUtil;
import com.horizon.utils.StringUtil;
import com.horizon.utils.json.JsonUtil;
import com.horizon.utils.json.filters.Null2EmptyValueFilter;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public abstract class SuperController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String RESTYPE_SUCCESS = "success";
    private static final String RESTYPE_ERROR = "err";
    @Autowired
    protected HttpServletRequest req;
    @Value(value="${sys.path}")
    protected String sysPath;
    @Value(value="${url.prefix}")
    protected String urlPrefix;
    @Value(value="${url.suffix}")
    protected String urlSuffix;
    @Value(value="${view.suffix}")
    protected String viewSuffix;
    @Value(value="${view.prefix}")
    protected String viewPrefix;

    protected String redirectTo(String url) {
        StringBuilder rto = new StringBuilder("redirect:");
        rto.append(url);
        rto.append(this.viewSuffix);
        return rto.toString();
    }

    protected String render(String url) {
        StringBuilder rto = new StringBuilder();
        String preFix = "";
        if (Objects.equal((Object)this.viewPrefix, (Object)"/")) {
            preFix = this.sysPath;
        } else if (this.sysPath.startsWith(this.viewPrefix)) {
            preFix = this.sysPath.replaceAll(this.viewPrefix, "");
        }
        rto.append(preFix);
        rto.append(url);
        return rto.toString();
    }

    protected String renderType(boolean isOk, String ... msg) {
        String type = isOk ? RESTYPE_SUCCESS : RESTYPE_ERROR;
        HashMap resMap = Maps.newHashMap();
        resMap.put("restype", type);
        resMap.put("msg", msg);
        return this.renderJson(resMap);
    }

    protected String renderJson(Object object) {
        return JsonUtil.toJson(object, new SerializeFilter[]{new Null2EmptyValueFilter(), new ValueFilter(){

            public Object process(Object object, String name, Object value) {
                if (value instanceof String) {
                    return StringUtil.decode((String)value);
                }
                return value;
            }
        }});
    }

    protected <T> ViewData<T> pageViewData(ICoreService<T> service, T entity) {
        ViewData<T> viewData = this.pageViewData();
        List<T> datas = service.findParam(entity);
        viewData.setDatas(datas);
        return viewData;
    }

    protected <T> ViewData<T> pageViewData() {
        ViewData<T> viewData = this.getViewData();
        String start = this.req.getParameter("iDisplayStart");
        String pageSize = this.req.getParameter("iDisplayLength");
        start = StringUtil.hasValue(start) ? start : "1";
        pageSize = StringUtil.hasValue(pageSize) && !"-1".equals(pageSize) ? pageSize : "0";
        PageHelper.offsetPage(Integer.parseInt(start), Integer.parseInt(pageSize), viewData.getOrderBy());
        return viewData;
    }

    protected <T> ViewData<T> getViewData() {
        String sEcho = this.req.getParameter("sEcho");
        String orderBy = this.createOrderSql(this.req);
        ViewData viewData = new ViewData();
        viewData.setsEcho(sEcho);
        viewData.setOrderBy(orderBy);
        return viewData;
    }

    protected <T> T setSearchParam(Class<T> cls) {
        String sSearchVal;
        List searchClms;
        String searchClm = this.req.getParameter("sColumns");
        HashMap map = Maps.newHashMap();
        if (StringUtil.hasValue(searchClm) && (searchClms = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)searchClm)) != null && !searchClms.isEmpty()) {
            int sSize = searchClms.size();
            for (int i = 0; i < sSize; ++i) {
                String val = this.req.getParameter("sSearch_" + i);
                if (!StringUtil.hasValue(val)) continue;
                String clm = this.req.getParameter("mDataProp_" + i);
                map.put(clm, "%" + val + "%");
            }
        }
        if (StringUtil.hasValue(sSearchVal = this.req.getParameter("sSearch"))) {
            map.put("search", "%" + sSearchVal + "%");
        }
        String json = JsonUtil.toJson(map);
        return JsonUtil.fromJson(json, cls);
    }

    protected String createOrderSql(HttpServletRequest request) {
        String orderBy = "";
        String sortColumnIndex = request.getParameter("iSortCol_0");
        if (StringUtil.hasValue(sortColumnIndex)) {
            String sortType = request.getParameter("sSortDir_0");
            String sortColumn = request.getParameter("sColumns");
            if (StringUtil.hasValue(sortColumn) && "DESC".equalsIgnoreCase(sortType) || "ASC".equalsIgnoreCase(sortType)) {
                String[] colums = sortColumn.split(",");
                int idx = Integer.parseInt(sortColumnIndex);
                orderBy = colums[idx] + " " + sortType;
            }
        }
        return orderBy;
    }

    protected void addMessage(Model model, String ... messages) {
        StringBuilder sb = new StringBuilder();
        for (String message : messages) {
            sb.append(message).append(messages.length > 1 ? "<br/>" : "");
        }
        model.addAttribute("message", (Object)sb.toString());
    }

    protected void addMessage(RedirectAttributes redirectAttributes, String ... messages) {
        StringBuilder sb = new StringBuilder();
        for (String message : messages) {
            sb.append(message).append(messages.length > 1 ? "<br/>" : "");
        }
        redirectAttributes.addFlashAttribute("message", (Object)sb.toString());
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(text == null ? null : StringEscapeUtils.escapeHtml4((String)text.trim()));
            }

            @Override
            public String getAsText() {
                Object value = this.getValue();
                return value != null ? value.toString() : "";
            }
        });
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(DateUtil.getDate(text));
            }
        });
    }
}

