/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.core.cluster.lifecycle;

import com.horizon.common.base.Objects;
import com.horizon.core.cluster.lifecycle.ClusterSyncExecutor;
import com.horizon.datasource.config.DatabaseConnectionInfo;
import com.horizon.db.xconnection.provider.ConnectionProviderFactory;
import com.horizon.utils.NetWorkUtils;
import java.util.List;

public class DataSourceClearExecutor
implements ClusterSyncExecutor {
    private String deployAddress;
    private List<String> removeIdentifiers;

    @Override
    public void execute() {
        String hostIp = NetWorkUtils.getHostIp();
        String pid = NetWorkUtils.getPID();
        String deployAddress = hostIp + '@' + pid;
        if (!Objects.equal((Object)deployAddress, (Object)this.deployAddress) && this.removeIdentifiers != null && !this.removeIdentifiers.isEmpty()) {
            for (String identifier : this.removeIdentifiers) {
                ConnectionProviderFactory instance = ConnectionProviderFactory.getInstance();
                DatabaseConnectionInfo databaseConnectionInfo = instance.getDatabaseConnectionInfo(identifier);
                if (databaseConnectionInfo == null) continue;
                instance.distoryDatabaseInfo(identifier);
            }
        }
    }

    public DataSourceClearExecutor(List<String> removeIdentifiers) {
        this.removeIdentifiers = removeIdentifiers;
    }

    public void setDeployAddress(String deployAddress) {
        this.deployAddress = deployAddress;
    }
}

