/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.memcached;

import com.horizon.cache.adapter.MemcacheAdapter;
import com.horizon.cache.adapter.RedisAdapter;
import com.horizon.cache.api.HCacheManagerFactory;
import com.horizon.cache.api.modules.memcache.HMemcacheCache;
import com.horizon.cache.api.modules.redis.HRedisCache;
import com.horizon.cache.memcached.IMemcached;
import com.horizon.core.HorizonCore;
import com.horizon.exception.HorizonException;
import com.horizon.profile.AppConfig;
import com.horizon.utils.StringUtil;

public class MemcachedFactory {
    private static volatile MemcachedFactory cacheFactory;

    private MemcachedFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MemcachedFactory newInstance() {
        if (cacheFactory != null) return cacheFactory;
        Class<MemcachedFactory> clazz = MemcachedFactory.class;
        synchronized (MemcachedFactory.class) {
            if (cacheFactory != null) return cacheFactory;
            cacheFactory = new MemcachedFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cacheFactory;
        }
    }

    public IMemcached getMemoryCache(String name, String tenantCode) {
        String cacheType = AppConfig.get("cache", "cache.type");
        Boolean enable = AppConfig.getBoolean("cache", cacheType.toLowerCase() + ".enable");
        if (enable == null || !enable.booleanValue()) {
            throw new HorizonException(cacheType + " cache is not enable");
        }
        if (!StringUtil.hasValue(tenantCode)) {
            tenantCode = HorizonCore.TENANT_CODE.value();
        }
        if ("redis".equalsIgnoreCase(cacheType)) {
            HRedisCache cache = (HRedisCache)HCacheManagerFactory.getCacheByType("redis", tenantCode + ";" + name, null);
            return new RedisAdapter(cache);
        }
        if ("memcache".equalsIgnoreCase(cacheType)) {
            HMemcacheCache cache = (HMemcacheCache)HCacheManagerFactory.getCacheByType("memcache", tenantCode + ";" + name, null);
            return new MemcacheAdapter(cache);
        }
        throw new HorizonException("\u4e0d\u652f\u6301\u7684\u7f13\u5b58\u7c7b\u578b");
    }
}

