/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.service.aop.util;

import com.horizon.cache.api.service.aop.entity.MethodArgSource;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;

public class MethodUtil {
    private static LocalVariableTableParameterNameDiscoverer methodUtil = new LocalVariableTableParameterNameDiscoverer();

    public static Method getMethod(ProceedingJoinPoint thisJoinPoint) {
        MethodSignature s = (MethodSignature)thisJoinPoint.getSignature();
        Method method = s.getMethod();
        try {
            return thisJoinPoint.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static MethodArgSource[] getJoinPointSource(ProceedingJoinPoint thisJoinPoint, Method method) {
        Object[] values = thisJoinPoint.getArgs();
        if (values == null || values.length <= 0) {
            return null;
        }
        if (method == null) {
            method = MethodUtil.getMethod(thisJoinPoint);
        }
        String[] paraNames = methodUtil.getParameterNames(method);
        Class<?>[] clazz = method.getParameterTypes();
        MethodArgSource[] sources = new MethodArgSource[values.length];
        for (int i = 0; i < values.length; ++i) {
            sources[i] = new MethodArgSource(clazz[i], paraNames[i], values[i]);
        }
        return sources;
    }
}

