/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.service.aop.impl;

import com.horizon.cache.api.HCacheClient;
import com.horizon.cache.api.annotation.HCacheable;
import com.horizon.cache.api.service.aop.AbstractCacheAnnoDoer;
import com.horizon.cache.api.service.aop.entity.AopCacheContext;
import com.horizon.utils.StringUtil;

public class CacheableAnnoDoer
extends AbstractCacheAnnoDoer {
    private HCacheable hzCacheable;

    public CacheableAnnoDoer(HCacheable hzCacheable) {
        this.hzCacheable = hzCacheable;
    }

    @Override
    public void doWithAnno(AopCacheContext aopCacheContext) {
        String value = this.hzCacheable.value();
        String key = this.hzCacheable.key();
        String condition = this.hzCacheable.condition();
        long timeout = this.hzCacheable.timeout();
        String nativeTimeout = this.hzCacheable.nativeTimeout();
        key = this.nativeStringFromSpel(key, aopCacheContext);
        if (StringUtil.hasValue(nativeTimeout)) {
            timeout = this.nativeFromSpel(key, aopCacheContext, Long.TYPE);
        }
        if (!this.isNeedCache(condition, aopCacheContext)) {
            return;
        }
        if (!HCacheClient.keyExists(value, key)) {
            aopCacheContext.proceed();
            if (aopCacheContext.isSuccess()) {
                HCacheClient.put(value, key, aopCacheContext.getResult(), timeout);
            }
        } else {
            Object result = HCacheClient.get(value, key);
            aopCacheContext.cacheProcess(result);
        }
    }

    private boolean isNeedCache(String condition, AopCacheContext aopCacheContext) {
        if (!StringUtil.hasValue(condition)) {
            return true;
        }
        return super.nativeFromSpel(condition, aopCacheContext, Boolean.TYPE);
    }

    private String nativeStringFromSpel(String key, AopCacheContext aopCacheContext) {
        return super.nativeFromSpel(key, aopCacheContext, String.class);
    }
}

