/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.service.aop.impl;

import com.horizon.cache.api.HCacheClient;
import com.horizon.cache.api.annotation.HCacheEvict;
import com.horizon.cache.api.service.aop.AbstractCacheAnnoDoer;
import com.horizon.cache.api.service.aop.entity.AopCacheContext;
import com.horizon.cache.api.service.aop.entity.MethodArgSource;
import com.horizon.utils.StringUtil;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class CacheEvictAnnoDoer
extends AbstractCacheAnnoDoer {
    private HCacheEvict hzCacheEvict;

    public CacheEvictAnnoDoer(HCacheEvict hzCacheEvict) {
        this.hzCacheEvict = hzCacheEvict;
    }

    @Override
    public void doWithAnno(AopCacheContext aopCacheContext) {
        boolean beforeInvocation = this.hzCacheEvict.beforeInvocation();
        if (beforeInvocation) {
            this.evictsCache(aopCacheContext);
            aopCacheContext.proceed();
        } else {
            aopCacheContext.proceed();
            this.evictsCache(aopCacheContext);
        }
    }

    private void evictsCache(AopCacheContext aopCacheContext) {
        String condition = this.hzCacheEvict.condition();
        if (this.isNeedCacheEvicts(condition, aopCacheContext)) {
            String value = this.hzCacheEvict.value();
            String key = this.hzCacheEvict.key();
            boolean allEntity = this.hzCacheEvict.allEntries();
            value = this.nativeFromSpel(value, aopCacheContext, String.class);
            key = this.nativeFromSpel(key, aopCacheContext, String.class);
            if (allEntity) {
                HCacheClient.clear(value);
            } else {
                HCacheClient.remove(value, key);
            }
        }
    }

    private boolean isNeedCacheEvicts(String condition, AopCacheContext aopCacheContext) {
        if (!StringUtil.hasValue(condition)) {
            return true;
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        MethodArgSource[] args = aopCacheContext.getArgs();
        if (args != null) {
            for (MethodArgSource methodArgSource : args) {
                context.setVariable(methodArgSource.getArgName(), methodArgSource.getArgValue());
            }
        }
        if (aopCacheContext.isRuned()) {
            context.setVariable("result", aopCacheContext.getResult());
        }
        return (Boolean)this.parser.parseExpression(condition).getValue((EvaluationContext)context, Boolean.TYPE);
    }
}

