/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.service.aop.entity;

import com.horizon.cache.api.service.aop.entity.MethodArgSource;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;

public class AopCacheContext {
    private ProceedingJoinPoint thisJoinPoint;
    private MethodArgSource[] args;
    private Method method;
    private Object result;
    private boolean runed = false;
    private Throwable throwable;
    private Class<?> returnType;

    public AopCacheContext(ProceedingJoinPoint thisJoinPoint, MethodArgSource[] args, Method method, Class<?> returnType) {
        this.thisJoinPoint = thisJoinPoint;
        this.args = args;
        this.method = method;
        this.returnType = returnType;
    }

    public Object proceed() {
        if (!this.isRuned()) {
            try {
                this.result = this.thisJoinPoint.proceed();
            }
            catch (Throwable e) {
                this.throwable = e;
            }
            this.runed = true;
        }
        return this.result;
    }

    public void cacheProcess(Object result) {
        if (!this.isRuned()) {
            this.runed = true;
            this.result = result;
        }
    }

    public boolean isThrowedException() {
        return this.throwable != null;
    }

    public boolean isSuccess() {
        return this.isRuned() && !this.isThrowedException();
    }

    public ProceedingJoinPoint getThisJoinPoint() {
        return this.thisJoinPoint;
    }

    public MethodArgSource[] getArgs() {
        return this.args;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getResult() {
        return this.result;
    }

    public boolean isRuned() {
        return this.runed;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }
}

