/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.service.aop;

import com.horizon.cache.api.annotation.HCacheEvict;
import com.horizon.cache.api.annotation.HCacheEvicts;
import com.horizon.cache.api.annotation.HCacheable;
import com.horizon.cache.api.service.aop.AbstractCacheAnnoDoer;
import com.horizon.cache.api.service.aop.entity.AopCacheContext;
import com.horizon.cache.api.service.aop.entity.MethodArgSource;
import com.horizon.cache.api.service.aop.impl.CacheEvictAnnoDoer;
import com.horizon.cache.api.service.aop.impl.CacheableAnnoDoer;
import com.horizon.cache.api.service.aop.util.MethodUtil;
import com.horizon.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Aspect
@Configuration
@EnableAspectJAutoProxy
public class PointCuts {
    @Pointcut(value="@annotation(com.horizon.cache.api.annotation.HCacheable)")
    private void executionOfCacheAble() {
    }

    @Pointcut(value="@annotation(com.horizon.cache.api.annotation.HCacheEvict)")
    private void executionOfCacheEvict() {
    }

    @Pointcut(value="@annotation(com.horizon.cache.api.annotation.HCacheEvicts)")
    private void executionOfCacheEvicts() {
    }

    @Around(value="executionOfCacheAble()||executionOfCacheEvict()||executionOfCacheEvicts()")
    public Object cacheAnnotationExecuter(ProceedingJoinPoint thisJoinPoint) throws Throwable {
        Method method = MethodUtil.getMethod(thisJoinPoint);
        MethodArgSource[] args = MethodUtil.getJoinPointSource(thisJoinPoint, method);
        AopCacheContext context = new AopCacheContext(thisJoinPoint, args, method, method.getReturnType());
        Annotation[] annos = method.getAnnotations();
        List<AbstractCacheAnnoDoer> cacheable = this.getAnnoDoer(annos);
        for (AbstractCacheAnnoDoer iCacheAnnoDoer : cacheable) {
            iCacheAnnoDoer.doWithAnno(context);
        }
        if (!context.isRuned()) {
            context.proceed();
        }
        if (context.isThrowedException()) {
            throw context.getThrowable();
        }
        return context.getResult();
    }

    private List<AbstractCacheAnnoDoer> getAnnoDoer(Annotation[] annos) {
        ArrayList cacheables = Lists.newArrayList();
        ArrayList cacheEvict = Lists.newArrayList();
        for (Annotation annotation : annos) {
            HCacheEvict[] evicts;
            Class<? extends Annotation> clazz = annotation.annotationType();
            if (clazz.equals(HCacheable.class)) {
                cacheables.add(new CacheableAnnoDoer((HCacheable)annotation));
            }
            if (clazz.equals(HCacheEvict.class)) {
                cacheables.add(new CacheEvictAnnoDoer((HCacheEvict)annotation));
            }
            if (!clazz.equals(HCacheEvicts.class)) continue;
            HCacheEvicts cacheEvicts = (HCacheEvicts)annotation;
            for (HCacheEvict hzCacheEvict : evicts = cacheEvicts.evicts()) {
                cacheables.add(new CacheEvictAnnoDoer(hzCacheEvict));
            }
        }
        cacheables.addAll(cacheEvict);
        return cacheables;
    }
}

