/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.service;

import com.horizon.utils.StringUtil;
import java.util.Map;

public class HCacheProperties {
    private Map map;

    public HCacheProperties(Map map) {
        this.map = map;
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public String get(String key) {
        return (String)this.map.get(key);
    }

    public Integer getInteger(String key) {
        String value = this.get(key);
        if (StringUtil.hasValue(value)) {
            return Integer.parseInt(value);
        }
        return null;
    }

    public Double getDouble(String key) {
        String value = this.get(key);
        if (StringUtil.hasValue(value)) {
            return Double.parseDouble(value);
        }
        return null;
    }

    public Float getFloat(String key) {
        String value = this.get(key);
        if (StringUtil.hasValue(value)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        return null;
    }

    public Long getLong(String key) {
        String value = this.get(key);
        if (StringUtil.hasValue(value)) {
            return Long.parseLong(value);
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        String value = this.get(key);
        if (StringUtil.hasValue(value)) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    public String[] getArray(String key) {
        return this.getArray(key, ",");
    }

    public String[] getArray(String key, String regularly) {
        String value = this.get(key);
        return value.split(regularly);
    }
}

