/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.redis;

import com.caucho.hessian.io.Hessian2Input;
import com.horizon.cache.api.HCacheManagerFactory;
import com.horizon.cache.api.IHCacheManager;
import com.horizon.cache.api.modules.redis.HRedisCacheManager;
import com.horizon.common.base.Objects;
import com.horizon.common.collect.Lists;
import com.horizon.common.collect.Maps;
import com.horizon.core.common.event.LocalEvent;
import com.horizon.core.common.event.SuperEvent;
import com.horizon.core.init.HorizonInitAble;
import com.horizon.exception.HorizonException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.ResolvableType;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class HorizonApplicationEventMulticaster
extends SimpleApplicationEventMulticaster
implements HorizonInitAble,
MessageListener {
    private static final String CHANNEL_NAME = "horizon_events";
    private static Logger logger = LoggerFactory.getLogger(HorizonApplicationEventMulticaster.class);
    private RedisMessageListenerContainer container = null;

    public void multicastEvent(ApplicationEvent event, ResolvableType eventType) {
        if (SuperEvent.class.isAssignableFrom(event.getClass()) && !LocalEvent.class.isAssignableFrom(event.getClass())) {
            String key = event.getClass().getName();
            logger.debug("\u53d1\u5e03\u5206\u5e03\u7684\u4e8b\u4ef6:{}", (Object)key);
            RedisTemplate<String, Object> redisTemplate = this.getRedisTemplate();
            redisTemplate.convertAndSend(CHANNEL_NAME, (Object)event);
        } else {
            this.multicastEvent4Other(event, eventType);
        }
    }

    private void multicastEvent4Other(ApplicationEvent event, ResolvableType eventType) {
        super.multicastEvent(event, eventType);
    }

    public void onMessage(Message message, byte[] pattern) {
        RedisTemplate<String, Object> redisTemplate = this.getRedisTemplate();
        String channel = (String)redisTemplate.getStringSerializer().deserialize(message.getChannel());
        if (!Objects.equal((Object)CHANNEL_NAME, (Object)channel)) {
            return;
        }
        SuperEvent event = (SuperEvent)((Object)this.hessian2Deserialize(message.getBody()));
        logger.debug("\u83b7\u53d6\u5230\u4e00\u4e2a\u5206\u5e03\u5f0f\u6d88\u606f:" + ((Object)((Object)event)).getClass() + ",source:" + event.getSource());
        if (!SuperEvent.class.isAssignableFrom(((Object)((Object)event)).getClass()) || LocalEvent.class.isAssignableFrom(((Object)((Object)event)).getClass())) {
            return;
        }
        this.multicastEvent4Other(event, null);
    }

    @Override
    public void start() {
        RedisTemplate<String, Object> redisTemplate = this.getRedisTemplate();
        RedisMessageListenerContainer containerTmp = new RedisMessageListenerContainer();
        containerTmp.setConnectionFactory(redisTemplate.getConnectionFactory());
        HashMap listeners = Maps.newHashMap();
        listeners.put(this, Lists.newArrayList((Object[])new ChannelTopic[]{new ChannelTopic(CHANNEL_NAME)}));
        containerTmp.setMessageListeners((Map)listeners);
        containerTmp.setBeanName("horizonMessageListenerContainer");
        containerTmp.afterPropertiesSet();
        this.container = containerTmp;
        containerTmp.start();
    }

    @Override
    public void destory() {
        if (this.container != null) {
            try {
                this.container.stop();
                this.container.destroy();
            }
            catch (Exception e) {
                logger.warn("redis \u5206\u5e03\u76d1\u542c\u9500\u6bc1\u5931\u8d25");
            }
        }
    }

    @Override
    public int getSort() {
        return 20;
    }

    private RedisTemplate<String, Object> getRedisTemplate() {
        IHCacheManager cacheManager = HCacheManagerFactory.get("redis");
        if (cacheManager != null && cacheManager instanceof HRedisCacheManager) {
            return ((HRedisCacheManager)cacheManager).getRedisTemplate();
        }
        throw new HorizonException("\u83b7\u53d6 redisCacheManager \u5931\u8d25\uff0c\u8bf7\u68c0\u67e5cache.properties\u4e2dcache.type\u7684\u53c2\u6570\u662f\u5426\u8bbe\u7f6e\u4e3aredis");
    }

    private Object hessian2Deserialize(byte[] bytes) {
        if (bytes != null) {
            Hessian2Input hessian2Input = new Hessian2Input((InputStream)new ByteArrayInputStream(bytes));
            try {
                hessian2Input.startMessage();
                Object o = hessian2Input.readObject();
                hessian2Input.completeMessage();
                hessian2Input.close();
                return o;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

