/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.redis;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class Hessian2RedisSerializer<T>
implements RedisSerializer<T> {
    public byte[] serialize(Object o) throws SerializationException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Hessian2Output hessian2Output = new Hessian2Output((OutputStream)byteArrayOutputStream);
            hessian2Output.startMessage();
            hessian2Output.writeObject(o);
            hessian2Output.completeMessage();
            hessian2Output.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public T deserialize(byte[] bytes) throws SerializationException {
        if (null == bytes) {
            return null;
        }
        Hessian2Input hessian2Input = new Hessian2Input((InputStream)new ByteArrayInputStream(bytes));
        try {
            hessian2Input.startMessage();
            Object o = hessian2Input.readObject();
            hessian2Input.completeMessage();
            hessian2Input.close();
            return (T)o;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

