/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.redis;

import com.horizon.cache.api.IHCache;
import com.horizon.cache.api.IHCacheManager;
import com.horizon.cache.api.exception.HCacheException;
import com.horizon.cache.api.modules.redis.HRedisCache;
import com.horizon.cache.api.modules.redis.Hessian2RedisSerializer;
import com.horizon.cache.api.service.HCacheProperties;
import com.horizon.common.collect.Lists;
import com.horizon.profile.AppConfig;
import com.horizon.utils.StringUtil;
import java.util.ArrayList;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

public class HRedisCacheManager
implements IHCacheManager {
    private static final String profile = "cache";
    private RedisTemplate<String, Object> redisTemplate;
    private JedisConnectionFactory redisConnectionFactory = null;
    private HCacheProperties properties;

    public HRedisCacheManager(HCacheProperties properties) {
        this.properties = properties;
    }

    public HRedisCacheManager() {
        this.properties = new HCacheProperties(AppConfig.getProfile(profile));
    }

    @Override
    public IHCache getCache(String cacheName, Long timeout) {
        return new HRedisCache(cacheName, this.redisTemplate);
    }

    @Override
    public String getType() {
        return "redis";
    }

    @Override
    public void init() throws HCacheException {
        this.destory();
        this.initClusterNode();
    }

    public void initClusterNode() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(this.properties.getInteger("redis.pool.maxActive").intValue());
        jedisPoolConfig.setMaxIdle(this.properties.getInteger("redis.pool.maxIdle").intValue());
        jedisPoolConfig.setMinIdle(this.properties.getInteger("redis.pool.minIdle").intValue());
        jedisPoolConfig.setMaxWaitMillis(this.properties.getLong("redis.pool.maxWait").longValue());
        jedisPoolConfig.setTestOnBorrow(this.properties.getBoolean("redis.pool.testOnBorrow").booleanValue());
        jedisPoolConfig.setTestOnReturn(this.properties.getBoolean("redis.pool.testOnReturn").booleanValue());
        Boolean isSentinel = this.properties.getBoolean("redis.sentinel");
        String[] redisHosts = this.properties.get("redis.host").split(";");
        String[] redisPorts = this.properties.get("redis.port").split(";");
        String[] redisNames = this.properties.get("redis.name").split(";");
        String[] redisPassword = this.properties.get("redis.passWord").split(";");
        try {
            if (redisHosts.length == 1 && redisPorts.length == 1) {
                this.redisConnectionFactory = new JedisConnectionFactory(jedisPoolConfig);
                this.redisConnectionFactory.setHostName(redisHosts[0]);
                this.redisConnectionFactory.setPort(Integer.parseInt(redisPorts[0]));
                this.redisConnectionFactory.setUsePool(true);
            } else if (isSentinel != null && isSentinel.booleanValue()) {
                RedisSentinelConfiguration configuration = new RedisSentinelConfiguration();
                ArrayList sentinelNodes = Lists.newArrayList();
                for (int i = 0; i < redisHosts.length; ++i) {
                    RedisNode node = new RedisNode(redisHosts[i], Integer.parseInt(redisPorts[i]));
                    if (i < redisNames.length && StringUtil.hasValue(redisNames[i])) {
                        node.setName(redisNames[i]);
                    }
                    if (i == 0) {
                        configuration.master((NamedNode)node);
                        continue;
                    }
                    sentinelNodes.add(node);
                }
                configuration.setSentinels((Iterable)sentinelNodes);
                this.redisConnectionFactory = new JedisConnectionFactory(configuration, jedisPoolConfig);
                this.redisConnectionFactory.setUsePool(true);
            } else {
                ArrayList clusterNode = Lists.newArrayList();
                RedisClusterConfiguration configuration = new RedisClusterConfiguration();
                for (int i = 0; i < redisHosts.length; ++i) {
                    RedisClusterNode node = new RedisClusterNode(redisHosts[i], Integer.parseInt(redisPorts[i]));
                    if (i < redisNames.length && StringUtil.hasValue(redisNames[i])) {
                        node.setName(redisNames[i]);
                    }
                    clusterNode.add(node);
                }
                configuration.setClusterNodes((Iterable)clusterNode);
                this.redisConnectionFactory = new JedisConnectionFactory(configuration, jedisPoolConfig);
                this.redisConnectionFactory.setUsePool(true);
            }
        }
        catch (Exception e) {
            this.destory();
            throw new HCacheException(e);
        }
        if (redisPassword != null && redisPassword.length > 0 && StringUtil.hasValue(redisPassword[0])) {
            this.redisConnectionFactory.setPassword(redisPassword[0]);
        }
        this.redisConnectionFactory.setTimeout(this.properties.getInteger("redis.timeout").intValue());
        this.redisConnectionFactory.afterPropertiesSet();
        this.redisTemplate = new RedisTemplate();
        this.redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        Hessian2RedisSerializer hessian2RedisSerializer = new Hessian2RedisSerializer();
        this.redisTemplate.setValueSerializer(hessian2RedisSerializer);
        this.redisTemplate.setConnectionFactory((RedisConnectionFactory)this.redisConnectionFactory);
        this.redisTemplate.afterPropertiesSet();
    }

    @Override
    public void destory() {
        if (this.redisConnectionFactory != null) {
            this.redisConnectionFactory.destroy();
        }
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

