/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.redis;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.horizon.cache.CacheUnit;
import com.horizon.cache.api.IHCache;
import com.horizon.cache.api.exception.HCacheException;
import com.horizon.cache.api.service.IHZSerializer;
import com.horizon.cache.api.service.serializers.HObjectSerializer;
import com.horizon.common.collect.Maps;
import com.horizon.profile.AppConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public class HRedisCache
implements IHCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(HRedisCache.class);
    private static IHZSerializer<Object> serializer = new HObjectSerializer();
    private final String ABOUT_FLOW_PATTERN = "HZFLOW*";
    private String ACTIVE_KEY_PATTERN = CacheUnit.ACTIVE.key("", "") + "*";
    private String GENERAL_KEY_PATTERN = CacheUnit.GENERAL.key("", "") + "*";
    private String name;
    private RedisTemplate<String, Object> redisTemplate;
    private static final String LOCKED = "TRUE";
    private static final Random RANDOM = new Random();

    public HRedisCache(String name, RedisTemplate<String, Object> redisTemplate) {
        this.name = name;
        this.redisTemplate = redisTemplate;
    }

    private String getNative(String key) {
        return this.name + ":" + key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object get(String key) {
        Object dd = this.redisTemplate.opsForValue().get((Object)this.getNative(key));
        return serializer.deserialize(dd);
    }

    @Override
    public void put(String key, Object value, Long timeout) {
        if (timeout == null) {
            timeout = AppConfig.getLong("cache", "default.cache.time");
        }
        ValueOperations oper = this.redisTemplate.opsForValue();
        if (timeout <= 0L) {
            oper.set((Object)this.getNative(key), serializer.serialize(value));
        } else {
            oper.set((Object)this.getNative(key), serializer.serialize(value), timeout.longValue(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void evict(String key) {
        this.redisTemplate.delete((Object)this.getNative(key));
    }

    @Override
    public void clear() {
        Set keys = this.redisTemplate.keys((Object)this.getNative("*"));
        this.redisTemplate.delete((Collection)keys);
    }

    public boolean putElement(String key, Object obj, int timeOut) {
        LOGGER.info("key = {" + key + "}  User = {" + obj + "} is Lock timer = {" + timeOut + "}");
        return true;
    }

    private String generalKey(String key) {
        return CacheUnit.GENERAL.key("", key);
    }

    private String activeKey(String key) {
        return CacheUnit.ACTIVE.key("", key);
    }

    public Object getElement(final String key, final boolean isLock) {
        Object object = this.redisTemplate.execute((RedisCallback)new RedisCallback<Object>(){

            public Object doInRedis(RedisConnection redisConnection) throws DataAccessException {
                Object obj = null;
                String generalKey = HRedisCache.this.getNative(HRedisCache.this.generalKey(key));
                byte[] keyBytes = HRedisCache.this.redisTemplate.getStringSerializer().serialize((Object)generalKey);
                if (redisConnection.exists(keyBytes).booleanValue()) {
                    if (isLock) {
                        HRedisCache.this.lock(key, 30);
                    }
                    byte[] vulBytes = redisConnection.get(keyBytes);
                    obj = HRedisCache.this.hessian2Desserialize(vulBytes);
                }
                return obj;
            }
        });
        LOGGER.info("key = {" + key + "}  Object = {" + object + "}");
        return object;
    }

    public boolean put(final String key, final Object obj, final int timeOut) {
        final String generalKey = this.getNative(this.generalKey(key));
        return (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection redisConnection) throws DataAccessException {
                boolean isLock = HRedisCache.this.lock(key, timeOut);
                if (isLock) {
                    byte[] bytes = HRedisCache.this.hessian2Serialize(obj);
                    Date expiryDate = new Date(timeOut * 60);
                    redisConnection.setEx(generalKey.getBytes(), expiryDate.getTime(), bytes);
                }
                LOGGER.info("key = {" + generalKey + "} timer = {" + timeOut + "}");
                redisConnection.close();
                return Boolean.TRUE;
            }
        });
    }

    public boolean put(final String key, final Object obj, final int timeOut, final boolean isActive) {
        return (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection redisConnection) throws DataAccessException {
                String generalKey = HRedisCache.this.getNative(HRedisCache.this.generalKey(key));
                String activeKey = HRedisCache.this.getNative(HRedisCache.this.activeKey(key));
                Date expiryDate = new Date(timeOut * 60);
                byte[] bytes = HRedisCache.this.hessian2Serialize(obj);
                redisConnection.setEx(generalKey.getBytes(), expiryDate.getTime(), bytes);
                if (isActive) {
                    redisConnection.setEx(activeKey.getBytes(), expiryDate.getTime(), bytes);
                    LOGGER.info("key = {" + activeKey + "} timer = {" + timeOut + "} status = {" + isActive + "} ");
                } else {
                    HRedisCache.this.redisTemplate.delete((Object)activeKey);
                    LOGGER.info("key = {" + activeKey + "} status = {" + isActive + "}");
                }
                HRedisCache.this.unLock(key);
                redisConnection.close();
                return Boolean.TRUE;
            }
        });
    }

    public boolean lock(final String key, final int timeOut) {
        Boolean isLock = (Boolean)this.redisTemplate.execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection redisConnection) throws DataAccessException {
                long nanoTime = System.nanoTime();
                long MILLI_NANO_TIME = 1000000L;
                long expireSeconds = 2000L * MILLI_NANO_TIME;
                try {
                    while (System.nanoTime() - nanoTime < expireSeconds) {
                        if (redisConnection.setNX(key.getBytes(), HRedisCache.LOCKED.getBytes()).booleanValue()) {
                            redisConnection.expire(key.getBytes(), (long)timeOut);
                            return Boolean.TRUE;
                        }
                        Thread.sleep(3L, RANDOM.nextInt(30));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("locking error", e);
                }
                LOGGER.info("key = {} \u9501\u7b49\u5f85", (Object)key);
                return false;
            }
        });
        LOGGER.info("key = {} \u8bbe\u7f6e\u9501\u5b9a\u65f6\u95f4 timeOut = {} \u9501\u5b9a\u72b6\u6001 LOCK = {} ", new Object[]{key, timeOut, isLock});
        return isLock;
    }

    private byte[] hessian2Serialize(Object obj) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Hessian2Output hessian2Output = new Hessian2Output((OutputStream)byteArrayOutputStream);
            hessian2Output.startMessage();
            hessian2Output.writeObject(obj);
            hessian2Output.completeMessage();
            hessian2Output.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Object hessian2Desserialize(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        Hessian2Input hessian2Input = new Hessian2Input((InputStream)new ByteArrayInputStream(bytes));
        try {
            hessian2Input.startMessage();
            Object o = hessian2Input.readObject();
            hessian2Input.completeMessage();
            hessian2Input.close();
            return o;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean removeElement(String key) {
        boolean isOK = Boolean.TRUE;
        try {
            this.redisTemplate.delete((Object)this.getNative(this.generalKey(key)));
            this.redisTemplate.delete((Object)this.getNative(this.activeKey(key)));
            LOGGER.debug("\u6e05\u9664\u6d41\u7a0b\u7f13\u5b58, key = {}", (Object)key);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("redis\u5220\u9664\u6d41\u7a0b\u7f13\u5b58\u9519\u8bef,key=" + key, (Throwable)e);
            return isOK;
        }
    }

    public boolean removeAllElement() {
        try {
            Set keys = this.redisTemplate.keys((Object)this.getNative("HZFLOW*"));
            this.redisTemplate.delete((Collection)keys);
            LOGGER.debug("\u6e05\u7a7a\u6d41\u7a0b\u7f13\u5b58!!!");
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("redis\u5220\u9664\u5168\u90e8\u6d41\u7a0b\u7f13\u5b58\u9519\u8bef", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    public boolean removeAll() {
        this.clear();
        return true;
    }

    public void unLock(String key) {
        this.redisTemplate.delete((Object)key);
        LOGGER.info("key = {} \u89e3\u9501 ", (Object)key);
    }

    public boolean generalKeyExists(String key) {
        boolean exists = false;
        try {
            return this.redisTemplate.hasKey((Object)this.getNative(this.generalKey(key)));
        }
        catch (Exception e) {
            throw new HCacheException(e);
        }
    }

    @Override
    public boolean exist(String key) {
        return this.redisTemplate.hasKey((Object)this.getNative(key));
    }

    public boolean elementKeyExists(String key) {
        try {
            return this.redisTemplate.hasKey((Object)this.getNative(this.generalKey(key)));
        }
        catch (Exception e) {
            throw new HCacheException(e);
        }
    }

    public boolean activeKeyExists(String key) {
        boolean exists = false;
        try {
            exists = this.redisTemplate.hasKey((Object)this.getNative(this.activeKey(key)));
            return exists;
        }
        catch (Exception e) {
            throw new HCacheException(e);
        }
    }

    public <T> Map<String, T> getActiveMapIgnoreName(Class<T> cls) {
        return this.getFlowMapCommon(cls, this.ACTIVE_KEY_PATTERN, CacheUnit.ACTIVE.key("", ""));
    }

    public <T> Map<String, T> getTotalMapIgnoreName(Class<T> cls) {
        return this.getFlowMapCommon(cls, this.GENERAL_KEY_PATTERN, CacheUnit.GENERAL.key("", ""));
    }

    public int getActiveCounterIgnoreName() {
        return this.getFlowCounter(this.ACTIVE_KEY_PATTERN);
    }

    public int getTotleCounterIgnoreName() {
        return this.getFlowCounter(this.GENERAL_KEY_PATTERN);
    }

    public <T> Map<String, T> getActiveMapByName(Class<T> cls) {
        return this.getFlowMapCommon(cls, this.ACTIVE_KEY_PATTERN, CacheUnit.ACTIVE.key("", ""));
    }

    public <T> Map<String, T> getActiveMapByName(Class<T> cls, int page, int pagenum) {
        return this.getFlowMapCommon(cls, this.ACTIVE_KEY_PATTERN, CacheUnit.ACTIVE.key("", ""), page, pagenum);
    }

    public <T> Map<String, T> getTotalMapByName(Class<T> cls) {
        return this.getFlowMapCommon(cls, this.GENERAL_KEY_PATTERN, CacheUnit.GENERAL.key("", ""));
    }

    public <T> Map<String, T> getTotalMapByName(Class<T> cls, int page, int pagenum) {
        return this.getFlowMapCommon(cls, this.GENERAL_KEY_PATTERN, CacheUnit.GENERAL.key("", ""), page, pagenum);
    }

    public int getActiveCounterByName() {
        return this.getFlowCounter(this.ACTIVE_KEY_PATTERN);
    }

    public int getTotleCounterByName() {
        return this.getFlowCounter(this.GENERAL_KEY_PATTERN);
    }

    private <T> Map<String, T> getFlowMapCommon(Class<T> cls, final String keyPattern, final String preReplace) {
        return (Map)this.redisTemplate.execute(new RedisCallback<Map<String, T>>(){

            public Map<String, T> doInRedis(RedisConnection redisConnection) throws DataAccessException {
                HashMap map = Maps.newHashMap();
                Set keys = HRedisCache.this.redisTemplate.keys((Object)HRedisCache.this.getNative(keyPattern));
                if (keys != null && !keys.isEmpty()) {
                    for (String elementKey : keys) {
                        byte[] keyBytes = HRedisCache.this.redisTemplate.getStringSerializer().serialize((Object)elementKey);
                        if (!redisConnection.exists(keyBytes).booleanValue()) continue;
                        byte[] vulBytes = redisConnection.get(keyBytes);
                        Object obj = HRedisCache.this.hessian2Desserialize(vulBytes);
                        String newPreReplace = HRedisCache.this.getNative(preReplace);
                        String key = elementKey.substring(elementKey.indexOf(newPreReplace)).replace(newPreReplace, "");
                        map.put(key, obj);
                    }
                }
                return map;
            }
        });
    }

    private <T> Map<String, T> getFlowMapCommon(Class<T> cls, final String keyPattern, final String preReplace, final int page, final int pagenum) {
        return (Map)this.redisTemplate.execute(new RedisCallback<Map<String, T>>(){

            public Map<String, T> doInRedis(RedisConnection redisConnection) throws DataAccessException {
                HashMap map = Maps.newHashMap();
                Set keys = HRedisCache.this.redisTemplate.keys((Object)HRedisCache.this.getNative(keyPattern));
                if (keys != null && !keys.isEmpty()) {
                    int start = (page - 1) * pagenum;
                    int end = page * pagenum;
                    int num = -1;
                    for (String elementKey : keys) {
                        byte[] keyBytes = HRedisCache.this.redisTemplate.getStringSerializer().serialize((Object)elementKey);
                        if (!redisConnection.exists(keyBytes).booleanValue() || ++num < start) continue;
                        if (num >= end) break;
                        byte[] vulBytes = redisConnection.get(keyBytes);
                        Object obj = HRedisCache.this.hessian2Desserialize(vulBytes);
                        String newPreReplace = HRedisCache.this.getNative(preReplace);
                        String key = elementKey.substring(elementKey.indexOf(newPreReplace)).replace(newPreReplace, "");
                        map.put(key, obj);
                    }
                }
                return map;
            }
        });
    }

    private int getFlowCounter(String pattern) {
        Set keySet = Collections.emptySet();
        try {
            keySet = this.redisTemplate.keys((Object)this.getNative(pattern));
        }
        catch (Exception e) {
            LOGGER.error("redis\u83b7\u53d6\u6d41\u7a0b\u603b\u6570\u9519\u8bef", (Throwable)e);
        }
        return keySet.size();
    }

    public static IHZSerializer<Object> getSerializer() {
        return serializer;
    }

    public static void setSerializer(IHZSerializer<Object> serializer) {
        HRedisCache.serializer = serializer;
    }
}

