/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.memcache;

import java.io.Serializable;
import java.util.Calendar;

public class QueueItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String itemId;
    private long createTime = -1L;
    private long holdTime;

    public QueueItem(String itemId) {
        this.itemId = itemId;
    }

    public QueueItem(String itemId, int expiryTime) {
        this.itemId = itemId;
        this.createTime = Calendar.getInstance().getTimeInMillis();
        this.holdTime = expiryTime * 60 * 1000;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public boolean isTimeOut() {
        long currentTime = Calendar.getInstance().getTimeInMillis();
        long timer = currentTime - this.createTime;
        return timer > this.holdTime;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueueItem) {
            QueueItem item = (QueueItem)obj;
            return this.itemId.equals(item.getItemId());
        }
        return false;
    }

    public int hashCode() {
        return this.itemId.hashCode();
    }
}

