/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.memcache;

import com.danga.MemCached.MemCachedClient;
import com.horizon.cache.api.IHCache;
import com.horizon.cache.api.IHCacheManager;
import com.horizon.cache.api.exception.HCacheException;
import com.horizon.cache.api.modules.memcache.HMemcacheCache;
import com.horizon.cache.api.service.HCacheProperties;
import com.horizon.profile.AppConfig;
import com.schooner.MemCached.SchoonerSockIOPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMemcacheCacheManager
implements IHCacheManager {
    private static Logger LOGGER = LoggerFactory.getLogger(HMemcacheCacheManager.class);
    private SchoonerSockIOPool pool = null;
    private MemCachedClient client = null;
    private static final String profile = "cache";
    protected static int DEFAULT_TIMEOUT;
    protected static int DEFAULT_EXPIRY_TIME;
    private HCacheProperties properties;

    public HMemcacheCacheManager(HCacheProperties properties) {
        this.properties = properties;
    }

    public HMemcacheCacheManager() {
        this.properties = new HCacheProperties(AppConfig.getProfile(profile));
    }

    @Override
    public IHCache getCache(String cacheName, Long timeout) {
        return new HMemcacheCache(cacheName, this.client);
    }

    @Override
    public String getType() {
        return "memcache";
    }

    @Override
    public void init() throws HCacheException {
        try {
            String[] servers = this.properties.getArray("memcached.servers", ";");
            this.pool = SchoonerSockIOPool.getInstance();
            this.pool.setServers(servers);
            this.pool.setFailover(this.properties.getBoolean("memcached.failover").booleanValue());
            this.pool.setInitConn(this.properties.getInteger("memcached.initConn").intValue());
            this.pool.setMinConn(this.properties.getInteger("memcached.minConn").intValue());
            this.pool.setMaxConn(this.properties.getInteger("memcached.maxConn").intValue());
            this.pool.setMaintSleep((long)this.properties.getInteger("memcached.maintSleep").intValue());
            this.pool.setNagle(this.properties.getBoolean("memcached.nagle").booleanValue());
            this.pool.setSocketTO(this.properties.getInteger("memcached.socketTO").intValue());
            this.pool.setAliveCheck(this.properties.getBoolean("memcached.aliveCheck").booleanValue());
            this.pool.initialize();
            this.client = new MemCachedClient();
            DEFAULT_TIMEOUT = this.properties.getInteger("memcached.timeOut");
            DEFAULT_EXPIRY_TIME = this.properties.getInteger("memcached.expiryTime");
        }
        catch (Exception e) {
            LOGGER.error("memcache init\u51fa\u9519 :" + e.getMessage());
            this.destory();
            throw new HCacheException(e);
        }
    }

    @Override
    public void destory() {
        if (this.pool != null) {
            this.pool.shutDown();
            this.pool = null;
        }
        if (this.client != null) {
            this.client = null;
        }
    }
}

