/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.memcache;

import com.danga.MemCached.MemCachedClient;
import com.horizon.cache.CacheUnit;
import com.horizon.cache.api.IHCache;
import com.horizon.cache.api.modules.memcache.HMemcacheCacheManager;
import com.horizon.cache.api.modules.memcache.QueueItem;
import com.horizon.cache.api.service.IHZSerializer;
import com.horizon.cache.api.service.serializers.HJsonSerializer;
import com.horizon.common.base.Splitter;
import com.horizon.profile.AppConfig;
import com.schooner.MemCached.MemcachedItem;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMemcacheCache
implements IHCache {
    private static Logger logger = LoggerFactory.getLogger(HMemcacheCache.class);
    private static IHZSerializer<String> serializer = new HJsonSerializer();
    private String name;
    private MemCachedClient client;

    public HMemcacheCache(String name, MemCachedClient client) {
        this.name = name;
        this.client = client;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String nativeKey(String key) {
        return this.name + "~" + key;
    }

    @Override
    public Object get(String key) {
        return serializer.deserialize((String)this.client.get(this.nativeKey(key)));
    }

    @Override
    public void put(String key, Object value, Long timeout) {
        if (timeout == null) {
            timeout = AppConfig.getLong("cache", "default.cache.time");
        }
        String nativeKey = this.nativeKey(key);
        Date expiryDate = new Date(timeout * 1000L);
        this.client.set(nativeKey, (Object)serializer.serialize(value), expiryDate);
    }

    @Override
    public boolean exist(String key) {
        return this.client.keyExists(this.nativeKey(key));
    }

    @Override
    public void evict(String key) {
        this.client.delete(this.nativeKey(key));
    }

    @Override
    public void clear() {
        this.client.flushAll();
    }

    public boolean put(String key, Object obj) {
        String genkey = CacheUnit.GENERAL.key(this.name, key);
        if (logger.isDebugEnabled()) {
            logger.debug("key {" + genkey + "} \u5b58\u5165\u5185\u5b58");
        }
        return this.client.set(genkey, obj);
    }

    public boolean put(String key, Object obj, int expiryTime) {
        String genkey = CacheUnit.GENERAL.key(this.name, key);
        Date expiryDate = new Date(expiryTime * 60 * 1000);
        if (logger.isDebugEnabled()) {
            logger.debug("key {" + genkey + "} \u5b58\u5165\u5185\u5b58,\u6709\u6548\u65f6\u95f4 {" + expiryDate + "}");
        }
        return this.client.set(genkey, obj, expiryDate);
    }

    public boolean put(String key, Object obj, int expiryTime, long casNo) {
        String genkey = CacheUnit.GENERAL.key(this.name, key);
        Date expiryDate = new Date(expiryTime * 60 * 1000);
        boolean isCas = this.client.cas(genkey, obj, expiryDate, casNo);
        if (logger.isDebugEnabled()) {
            logger.debug("key {" + genkey + "} \u5b58\u5165\u5185\u5b58,\u6709\u6548\u65f6\u95f4 {" + expiryDate + "} srcCas {" + casNo + "}");
        }
        return isCas;
    }

    public boolean put(String key, Object obj, int expiryTime, boolean isActive) {
        String generlKey = CacheUnit.GENERAL.key(this.name, key);
        String activeKey = CacheUnit.ACTIVE.key(this.name, key);
        Date expiryDate = new Date(expiryTime * 60 * 1000);
        boolean generlOk = this.client.set(generlKey, obj, expiryDate);
        logger.info("key \u4e3a {" + generlKey + "} \u5b58\u5165\u5185\u5b58,\u6709\u6548\u65f6\u95f4 {" + expiryTime + "} \u72b6\u6001 {" + isActive + "} ");
        if (isActive) {
            this.client.set(activeKey, obj, expiryDate);
        } else {
            this.client.delete(activeKey);
            logger.info("key \u4e3a {" + activeKey + "} \u4ece\u6d3b\u52a8\u5217\u8868\u4e2d\u5220\u9664 ");
        }
        return generlOk;
    }

    public boolean pollElement(String key, Object object) {
        this.putElement(key, object, HMemcacheCacheManager.DEFAULT_EXPIRY_TIME);
        boolean isOK = false;
        long begin = System.currentTimeMillis();
        String queueLockKey = CacheUnit.QUEUE.lockKey(this.name, key);
        do {
            LinkedBlockingQueue queue;
            QueueItem item;
            if ((item = (QueueItem)(queue = (LinkedBlockingQueue)this.client.get(queueLockKey)).element()).isTimeOut()) {
                logger.info("\u961f\u5217 {" + queueLockKey + "} \u5143\u7d20 {" + item.getItemId() + "} \u8d85\u65f6\uff0c\u8bf7\u6c42\u79fb\u9664\u961f\u5217");
                this.removeTimeOutElement(key, item.getItemId());
                continue;
            }
            isOK = item.getItemId().equals(object);
            long end = System.currentTimeMillis();
            if (end - begin < 30000L) continue;
            logger.info("\u5224\u65ad key {" + key + "} \u503c\u5bf9\u8c61 Object {" + object + "}  \u961f\u5217\u5934\u5143\u7d20\u8d85\u65f6 30s");
            return false;
        } while (!isOK);
        return isOK;
    }

    public boolean putElement(String key, Object object, int expiryTime) {
        String queueLockKey = CacheUnit.QUEUE.lockKey(this.name, key);
        MemcachedItem item = this.client.gets(queueLockKey);
        LinkedBlockingQueue<QueueItem> queue = null;
        QueueItem queueItem = new QueueItem(object.toString(), HMemcacheCacheManager.DEFAULT_TIMEOUT);
        if (item != null) {
            queue = (LinkedBlockingQueue<QueueItem>)item.getValue();
        } else {
            queue = new LinkedBlockingQueue<QueueItem>();
            this.putItem(queueItem, queue);
        }
        Date queueDate = new Date(expiryTime * 60 * 1000);
        boolean isOK = this.client.add(queueLockKey, queue, queueDate);
        if (!isOK) {
            MemcachedItem itemTmp = this.client.gets(queueLockKey);
            long casUnique = itemTmp.getCasUnique();
            this.queueAddItem(queueLockKey, queueItem, casUnique, isOK);
        } else {
            logger.info("\u521d\u59cb\u5316 key \u4e3a {" + queueLockKey + "} \u5185\u5b58\u961f\u5217 ");
        }
        return isOK;
    }

    public Object getElement(String key) {
        String genkey = CacheUnit.GENERAL.key(this.name, key);
        if (logger.isDebugEnabled()) {
            logger.debug(this.name + "  :  \u83b7\u53d6\u5185\u5b58 key {" + genkey + "} \u503c\u5bf9\u8c61 " + " == " + Thread.currentThread().getName());
        }
        return this.client.get(genkey);
    }

    public <T> T getElement(String key, Class<T> cls) {
        String genkey = CacheUnit.GENERAL.key(this.name, key);
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u5185\u5b58 key {" + genkey + "} \u503c\u5bf9\u8c61");
        }
        return (T)this.client.get(genkey);
    }

    private synchronized void queueAddItem(String queueLockKey, QueueItem item, long casUnique, boolean isOK) {
        MemcachedItem itemTmp = this.client.gets(queueLockKey);
        LinkedBlockingQueue queue = (LinkedBlockingQueue)itemTmp.getValue();
        long newCasUnique = itemTmp.getCasUnique();
        if (casUnique == newCasUnique) {
            this.putItem(item, queue);
            isOK = this.client.cas(queueLockKey, (Object)queue, newCasUnique);
            logger.info("key \u4e3a {" + queueLockKey + "} \u961f\u5217\u5143\u7d20 {" + item.getItemId() + "} \u5b58\u5165\u961f\u5217 size " + queue.size());
            return;
        }
        this.queueAddItem(queueLockKey, item, newCasUnique, isOK);
    }

    private void putItem(QueueItem item, BlockingQueue<QueueItem> queue) {
        try {
            queue.put(item);
        }
        catch (InterruptedException e) {
            logger.info("\u5185\u5b58\u961f\u5217\u589e\u52a0\u5143\u7d20\u5f02\u5e38");
            e.printStackTrace();
        }
    }

    public void removeElement(String key, Object obj) {
        String queueLockKey = CacheUnit.QUEUE.lockKey(this.name, key);
        QueueItem queueItem = new QueueItem(obj.toString());
        MemcachedItem memItem;
        while ((memItem = this.client.gets(queueLockKey)) != null) {
            LinkedBlockingQueue queue = (LinkedBlockingQueue)memItem.getValue();
            long casUnique = memItem.getCasUnique();
            if (null == queue || queue.isEmpty()) {
                return;
            }
            if (!queue.contains(queueItem)) {
                return;
            }
            this.queueDeleteItem(queueLockKey, queueItem, casUnique);
        }
        return;
    }

    private void removeTimeOutElement(String key, Object obj) {
        String queueLockKey = CacheUnit.QUEUE.lockKey(this.name, key);
        MemcachedItem memItem = this.client.gets(queueLockKey);
        if (memItem != null) {
            long casUnique = memItem.getCasUnique();
            LinkedBlockingQueue queue = (LinkedBlockingQueue)memItem.getValue();
            if (null != queue && !queue.isEmpty()) {
                QueueItem queueItem = new QueueItem(obj.toString());
                this.queueDeleteItem(queueLockKey, queueItem, casUnique);
            }
        }
    }

    private synchronized void queueDeleteItem(String queueLockKey, QueueItem item, long casUnique) {
        MemcachedItem memItem = this.client.gets(queueLockKey);
        LinkedBlockingQueue queue = (LinkedBlockingQueue)memItem.getValue();
        long newCasUnique = memItem.getCasUnique();
        if (casUnique == newCasUnique) {
            queue.remove(item);
            this.client.cas(queueLockKey, (Object)queue, newCasUnique);
            logger.info("key \u4e3a {" + queueLockKey + "} \u5185\u5b58\u961f\u5217 {" + item.getItemId() + "} \u5143\u7d20\u79fb\u9664 size " + queue.size());
            return;
        }
        this.queueDeleteItem(queueLockKey, item, newCasUnique);
    }

    public boolean unlock(String key) {
        logger.error("\u5185\u5b58\u4e2d key {" + key + "} \u8fdb\u884c\u5f3a\u5236\u89e3\u9501,\u7ed3\u679c\uff1a false");
        return false;
    }

    public boolean remove(String key) {
        this.client.delete(CacheUnit.GENERAL.key(this.name, key));
        this.client.delete(CacheUnit.GENERAL.lockKey(this.name, key));
        this.client.delete(CacheUnit.QUEUE.key(this.name, key));
        this.client.delete(CacheUnit.QUEUE.lockKey(this.name, key));
        return true;
    }

    public boolean removeAll() {
        return this.client.flushAll();
    }

    public boolean keyExists(String key) {
        return this.client.keyExists(key);
    }

    public boolean activeKeyExists(String key) {
        return this.client.keyExists(key);
    }

    public int getActiveCounter() {
        String activeKey = CacheUnit.ACTIVE.key(this.name, "");
        Set<String> keySet = this.keySet(-1, activeKey);
        int iTotal = keySet == null ? 0 : keySet.size();
        return iTotal;
    }

    public int getTotleCounter() {
        Map<String, Object> activeData = this.getActiveMap();
        int iTotal = 0;
        if (activeData != null && !activeData.isEmpty()) {
            iTotal = activeData.size();
        }
        return iTotal;
    }

    public Map<String, Object> getActiveMap() {
        Set<String> keySet = this.keySet(-1, CacheUnit.ACTIVE.key(this.name, ""));
        if (keySet != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                String workId = this.getActiveKey(key);
                String gernKey = CacheUnit.GENERAL.key(this.name, workId);
                if (this.keyExists(gernKey)) {
                    Object obj = this.client.get(gernKey);
                    map.put(workId, obj);
                    continue;
                }
                this.client.delete(key);
                iterator.remove();
            }
            return map;
        }
        return null;
    }

    public Map<String, Object> getActiveMap(int page, int pagenum) {
        Set<String> keySet = this.keySet(-1, CacheUnit.ACTIVE.key(this.name, ""));
        if (keySet != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator<String> iterator = keySet.iterator();
            int start = (page - 1) * pagenum;
            int end = page * pagenum;
            int num = -1;
            while (iterator.hasNext()) {
                String key = iterator.next();
                String workId = this.getActiveKey(key);
                String gernKey = CacheUnit.GENERAL.key(this.name, workId);
                if (this.keyExists(gernKey)) {
                    if (++num < start) continue;
                    if (num >= end) break;
                    Object obj = this.client.get(gernKey);
                    map.put(workId, obj);
                    continue;
                }
                this.client.delete(key);
                iterator.remove();
            }
            return map;
        }
        return null;
    }

    private String getActiveKey(String key) {
        List list = Splitter.on((String)"-").omitEmptyStrings().splitToList((CharSequence)key);
        return (String)list.get(1);
    }

    public Map<String, Object> getTotleMap() {
        Set<String> keySet = this.keySet(-1, CacheUnit.GENERAL.key(this.name, ""));
        if (keySet != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (this.keyExists(key)) {
                    Object obj = this.client.get(key);
                    String mapKey = this.getActiveKey(key);
                    map.put(mapKey, obj);
                    continue;
                }
                this.client.delete(key);
                iterator.remove();
            }
            return map;
        }
        return null;
    }

    public Map<String, Object> getTotleMap(int page, int pagenum) {
        Set<String> keySet = this.keySet(-1, CacheUnit.GENERAL.key(this.name, ""));
        if (keySet != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator<String> iterator = keySet.iterator();
            int start = (page - 1) * pagenum;
            int end = page * pagenum;
            int num = -1;
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (this.keyExists(key)) {
                    if (++num < start) continue;
                    if (num >= end) break;
                    Object obj = this.client.get(key);
                    String mapKey = this.getActiveKey(key);
                    map.put(mapKey, obj);
                    continue;
                }
                this.client.delete(key);
                iterator.remove();
            }
            return map;
        }
        return null;
    }

    private Set<String> keySet(int limit, String pixReg) {
        HashSet<String> keys = new HashSet<String>();
        Map statsItems = this.client.statsItems();
        if (statsItems == null || statsItems.isEmpty()) {
            return keys;
        }
        Map<String, Integer> dumps = this.getDumps(statsItems);
        if (dumps.isEmpty()) {
            return keys;
        }
        for (Map.Entry<String, Integer> dump : dumps.entrySet()) {
            int iDump = dump.getValue();
            Map cacheDumps = this.client.statsCacheDump(iDump, Integer.MAX_VALUE);
            for (Map.Entry cacheDump : cacheDumps.entrySet()) {
                Map mapKeys = (Map)cacheDump.getValue();
                for (Map.Entry key : mapKeys.entrySet()) {
                    String k = (String)key.getKey();
                    if ((k = this.decode(k)) == null || k.trim().equals("") || pixReg != null && !k.startsWith(pixReg)) continue;
                    keys.add(k);
                }
            }
        }
        return keys;
    }

    private Map<String, Integer> getDumps(Map<String, Map<String, String>> statsItems) {
        HashMap<String, Integer> dumps = new HashMap<String, Integer>();
        for (Map.Entry<String, Map<String, String>> statsItem : statsItems.entrySet()) {
            Map<String, String> items = statsItem.getValue();
            for (Map.Entry<String, String> item : items.entrySet()) {
                String itemName = item.getKey();
                String[] itemAtt = itemName.split(":");
                if (!itemAtt[2].startsWith("number")) continue;
                dumps.put(itemAtt[1], Integer.parseInt(itemAtt[1]));
            }
        }
        return dumps;
    }

    private String decode(String k) {
        try {
            k = URLDecoder.decode(k, "UTF-8");
        }
        catch (Exception ex) {
            logger.warn("keySet(int, String) - exception ignored", (Throwable)ex);
        }
        return k;
    }

    public static IHZSerializer<String> getSerializer() {
        return serializer;
    }

    public static void setSerializer(IHZSerializer<String> serializer) {
        HMemcacheCache.serializer = serializer;
    }
}

