/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.local;

import com.horizon.cache.api.IHCache;
import com.horizon.cache.api.service.IHZSerializer;
import com.horizon.cache.api.service.serializers.HObjectSerializer;
import com.horizon.common.base.Splitter;
import com.horizon.common.cache.Cache;
import com.horizon.profile.AppConfig;
import java.util.List;

public class HLocalCache
implements IHCache {
    private static IHZSerializer<Object> serializer = new HObjectSerializer();
    private IHCache cache;
    private Cache<String, Object> localCache;

    public HLocalCache(IHCache cache, Cache<String, Object> localCache) {
        this.cache = cache;
        this.localCache = localCache;
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public Object get(String key) {
        Object obj = this.localCache.getIfPresent((Object)key);
        if (obj != null) {
            return serializer.deserialize(obj);
        }
        obj = this.cache.get(key);
        if (this.isLocalCacheKey(key)) {
            this.localCache.put((Object)key, serializer.serialize(obj));
        }
        return obj;
    }

    @Override
    public void put(String key, Object value, Long timeout) {
        if (this.isLocalCacheKey(key)) {
            this.localCache.put((Object)key, serializer.serialize(value));
        }
        this.cache.put(key, value, timeout);
    }

    @Override
    public boolean exist(String key) {
        Object obj = this.localCache.getIfPresent((Object)key);
        if (obj != null) {
            return true;
        }
        return this.cache.exist(key);
    }

    @Override
    public void evict(String key) {
        this.cache.evict(key);
        this.localCache.invalidate((Object)key);
    }

    private boolean isLocalCacheKey(String key) {
        if (null == key) {
            return false;
        }
        String keys = AppConfig.get("cache", "localCacheKey");
        if (null == keys) {
            return false;
        }
        List keysList = Splitter.on((String)";").splitToList((CharSequence)keys);
        for (String keyStr : keysList) {
            if (!key.contains(keyStr)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.localCache.cleanUp();
    }
}

