/*
 * Decompiled with CFR 0.152.
 */
package com.horizon.cache.api.modules.guava;

import com.horizon.cache.api.IHCache;
import com.horizon.cache.api.IHCacheManager;
import com.horizon.cache.api.exception.HCacheException;
import com.horizon.cache.api.modules.guava.HGuavaCache;
import com.horizon.cache.api.service.HCacheProperties;
import com.horizon.common.cache.Cache;
import com.horizon.common.cache.CacheBuilder;
import com.horizon.common.collect.Maps;
import com.horizon.profile.AppConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HGuavaCacheManager
implements IHCacheManager {
    private static final String profile = "cache";
    private Map<String, Cache<String, Object>> cachesPool = Maps.newHashMap();
    private HCacheProperties properties;

    public HGuavaCacheManager(HCacheProperties properties) {
        this.properties = properties;
    }

    public HGuavaCacheManager() {
        this.properties = new HCacheProperties(AppConfig.getProfile(profile));
    }

    @Override
    public IHCache getCache(String cacheName, Long timeout) {
        Cache cache = this.cachesPool.get(cacheName);
        if (cache == null) {
            boolean bool = timeout == null || timeout == 0L;
            cache = CacheBuilder.newBuilder().maximumSize((long)this.properties.getInteger("guava.maximum.size").intValue()).expireAfterAccess((bool ? this.properties.getLong("guava.expire.after.access") : timeout).longValue(), TimeUnit.SECONDS).expireAfterWrite((bool ? this.properties.getLong("expire.after.write") : timeout).longValue(), TimeUnit.SECONDS).build();
            this.cachesPool.put(cacheName, (Cache<String, Object>)cache);
        }
        return new HGuavaCache(cacheName, cache);
    }

    @Override
    public String getType() {
        return "guava";
    }

    @Override
    public void init() throws HCacheException {
    }

    @Override
    public void destory() {
        for (Cache<String, Object> cache : this.cachesPool.values()) {
            cache.invalidateAll();
        }
        this.cachesPool.clear();
    }
}

